/*
 * Decompiled with CFR 0.152.
 */
package xcuitest.api;

import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00052\u00020\u0001:\u0006\u0005\u0006\u0007\b\t\nB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lxcuitest/api/NetworkException;", "Ljava/io/IOException;", "message", "", "(Ljava/lang/String;)V", "Companion", "ConnectionException", "NetworkErrorModel", "TimeoutException", "UnknownHostException", "UnknownNetworkException", "Lxcuitest/api/NetworkException$ConnectionException;", "Lxcuitest/api/NetworkException$TimeoutException;", "Lxcuitest/api/NetworkException$UnknownHostException;", "Lxcuitest/api/NetworkException$UnknownNetworkException;", "maestro-ios-driver"})
public abstract class NetworkException
extends IOException {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private NetworkException(String message) {
        super(message);
    }

    public /* synthetic */ NetworkException(String message, DefaultConstructorMarker $constructor_marker) {
        this(message);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002J\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0005\u00a8\u0006\b"}, d2={"Lxcuitest/api/NetworkException$Companion;", "", "()V", "displayErrorMessage", "", "Lxcuitest/api/NetworkException;", "toUserNetworkException", "Lxcuitest/api/NetworkException$NetworkErrorModel;", "maestro-ios-driver"})
    public static final class Companion {
        private Companion() {
        }

        private final String displayErrorMessage(NetworkException $this$displayErrorMessage) {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            NetworkException networkException = $this$displayErrorMessage;
            if (networkException instanceof TimeoutException) {
                string = "A timeout occurred while waiting for a response from the XCUITest server.";
            } else if (networkException instanceof ConnectionException) {
                string = "Unable to establish a connection to the XCUITest server.";
            } else if (networkException instanceof UnknownHostException) {
                string = "The host for the XCUITest server is unknown.";
            } else if (networkException instanceof UnknownNetworkException) {
                string = "An unknown network error occurred while communicating with the XCUITest server.";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return stringBuilder.append(string).append(" If the issue persists, consider raising a GitHub issue with the error message and any available logs for further assistance.").toString();
        }

        @NotNull
        public final NetworkErrorModel toUserNetworkException(@NotNull NetworkException $this$toUserNetworkException) {
            Intrinsics.checkNotNullParameter((Object)$this$toUserNetworkException, (String)"<this>");
            return new NetworkErrorModel(this.displayErrorMessage($this$toUserNetworkException), ExceptionsKt.stackTraceToString((Throwable)$this$toUserNetworkException));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lxcuitest/api/NetworkException$ConnectionException;", "Lxcuitest/api/NetworkException;", "message", "", "(Ljava/lang/String;)V", "maestro-ios-driver"})
    public static final class ConnectionException
    extends NetworkException {
        public ConnectionException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message, (DefaultConstructorMarker)null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lxcuitest/api/NetworkException$NetworkErrorModel;", "", "userFriendlyMessage", "", "stackTrace", "(Ljava/lang/String;Ljava/lang/String;)V", "getStackTrace", "()Ljava/lang/String;", "getUserFriendlyMessage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "maestro-ios-driver"})
    public static final class NetworkErrorModel {
        @NotNull
        private final String userFriendlyMessage;
        @NotNull
        private final String stackTrace;

        public NetworkErrorModel(@NotNull String userFriendlyMessage, @NotNull String stackTrace) {
            Intrinsics.checkNotNullParameter((Object)userFriendlyMessage, (String)"userFriendlyMessage");
            Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
            this.userFriendlyMessage = userFriendlyMessage;
            this.stackTrace = stackTrace;
        }

        @NotNull
        public final String getUserFriendlyMessage() {
            return this.userFriendlyMessage;
        }

        @NotNull
        public final String getStackTrace() {
            return this.stackTrace;
        }

        @NotNull
        public final String component1() {
            return this.userFriendlyMessage;
        }

        @NotNull
        public final String component2() {
            return this.stackTrace;
        }

        @NotNull
        public final NetworkErrorModel copy(@NotNull String userFriendlyMessage, @NotNull String stackTrace) {
            Intrinsics.checkNotNullParameter((Object)userFriendlyMessage, (String)"userFriendlyMessage");
            Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
            return new NetworkErrorModel(userFriendlyMessage, stackTrace);
        }

        public static /* synthetic */ NetworkErrorModel copy$default(NetworkErrorModel networkErrorModel, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = networkErrorModel.userFriendlyMessage;
            }
            if ((n & 2) != 0) {
                string2 = networkErrorModel.stackTrace;
            }
            return networkErrorModel.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "NetworkErrorModel(userFriendlyMessage=" + this.userFriendlyMessage + ", stackTrace=" + this.stackTrace + ')';
        }

        public int hashCode() {
            int result2 = this.userFriendlyMessage.hashCode();
            result2 = result2 * 31 + this.stackTrace.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NetworkErrorModel)) {
                return false;
            }
            NetworkErrorModel networkErrorModel = (NetworkErrorModel)other;
            if (!Intrinsics.areEqual((Object)this.userFriendlyMessage, (Object)networkErrorModel.userFriendlyMessage)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stackTrace, (Object)networkErrorModel.stackTrace);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lxcuitest/api/NetworkException$TimeoutException;", "Lxcuitest/api/NetworkException;", "message", "", "(Ljava/lang/String;)V", "maestro-ios-driver"})
    public static final class TimeoutException
    extends NetworkException {
        public TimeoutException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message, (DefaultConstructorMarker)null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lxcuitest/api/NetworkException$UnknownHostException;", "Lxcuitest/api/NetworkException;", "message", "", "(Ljava/lang/String;)V", "maestro-ios-driver"})
    public static final class UnknownHostException
    extends NetworkException {
        public UnknownHostException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message, (DefaultConstructorMarker)null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lxcuitest/api/NetworkException$UnknownNetworkException;", "Lxcuitest/api/NetworkException;", "message", "", "(Ljava/lang/String;)V", "maestro-ios-driver"})
    public static final class UnknownNetworkException
    extends NetworkException {
        public UnknownNetworkException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message, (DefaultConstructorMarker)null);
        }
    }
}

