/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.plugin;

import com.google.auto.service.AutoService;
import dev.mokkery.MockMode;
import dev.mokkery.plugin.MokkeryCommandLineProcessorKt;
import dev.mokkery.verify.VerifyModeSerializer;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Ldev/mokkery/plugin/MokkeryCommandLineProcessor;", "Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "<init>", "()V", "pluginId", "", "getPluginId", "()Ljava/lang/String;", "pluginOptions", "", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "getPluginOptions", "()Ljava/util/Collection;", "processOption", "", "option", "value", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "mokkery-plugin"})
@AutoService(value={CommandLineProcessor.class})
public final class MokkeryCommandLineProcessor
implements CommandLineProcessor {
    @NotNull
    private final String pluginId;
    @NotNull
    private final Collection<AbstractCliOption> pluginOptions;

    public MokkeryCommandLineProcessor() {
        this.pluginId = "dev.mokkery";
        Object[] objectArray = new CliOption[5];
        String string = MokkeryCommandLineProcessorKt.getMOCK_MODE_KEY().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        objectArray[0] = new CliOption(string, "enum class dev.mokkery.MockMode", "Default MockMode for every mock.", true, false);
        String string2 = MokkeryCommandLineProcessorKt.getVERIFY_MODE_KEY().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        objectArray[1] = new CliOption(string2, "sealed class dev.mokkery.VerifyMode", "Default VerifyMode for every verify block.", true, false);
        String string3 = MokkeryCommandLineProcessorKt.getALLOW_INDIRECT_SUPER_CALLS().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        objectArray[2] = new CliOption(string3, "Boolean", "Dictates if super calls to indirect types should be allowed whenever possible.", true, false);
        String string4 = MokkeryCommandLineProcessorKt.getIGNORE_INLINE_MEMBERS().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        objectArray[3] = new CliOption(string4, "Boolean", "Ignores inline members of mocked class if raised.", false, false);
        String string5 = MokkeryCommandLineProcessorKt.getIGNORE_FINAL_MEMBERS().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        objectArray[4] = new CliOption(string5, "Boolean", "Ignores final members of mocked class if raised.", false, false);
        this.pluginOptions = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public Collection<AbstractCliOption> getPluginOptions() {
        return this.pluginOptions;
    }

    public void processOption(@NotNull AbstractCliOption option, @NotNull String value, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        String string = option.getOptionName();
        if (Intrinsics.areEqual((Object)string, (Object)MokkeryCommandLineProcessorKt.getMOCK_MODE_KEY().toString())) {
            configuration.add(MokkeryCommandLineProcessorKt.getMOCK_MODE_KEY(), (Object)MockMode.valueOf((String)value));
        } else if (Intrinsics.areEqual((Object)string, (Object)MokkeryCommandLineProcessorKt.getVERIFY_MODE_KEY().toString())) {
            configuration.add(MokkeryCommandLineProcessorKt.getVERIFY_MODE_KEY(), (Object)VerifyModeSerializer.INSTANCE.deserialize(value));
        } else if (Intrinsics.areEqual((Object)string, (Object)MokkeryCommandLineProcessorKt.getALLOW_INDIRECT_SUPER_CALLS().toString())) {
            configuration.add(MokkeryCommandLineProcessorKt.getALLOW_INDIRECT_SUPER_CALLS(), (Object)Boolean.parseBoolean(value));
        } else if (Intrinsics.areEqual((Object)string, (Object)MokkeryCommandLineProcessorKt.getIGNORE_INLINE_MEMBERS().toString())) {
            configuration.add(MokkeryCommandLineProcessorKt.getIGNORE_INLINE_MEMBERS(), (Object)Boolean.parseBoolean(value));
        } else if (Intrinsics.areEqual((Object)string, (Object)MokkeryCommandLineProcessorKt.getIGNORE_FINAL_MEMBERS().toString())) {
            configuration.add(MokkeryCommandLineProcessorKt.getIGNORE_FINAL_MEMBERS(), (Object)Boolean.parseBoolean(value));
        } else {
            throw new IllegalStateException(("Unknown config option: " + option).toString());
        }
    }
}

