/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.plugin.diagnostics;

import dev.mokkery.plugin.core.MembersValidationMode;
import dev.mokkery.plugin.core.Mokkery;
import dev.mokkery.plugin.core.MokkeryConfigApiKt;
import dev.mokkery.plugin.diagnostics.MokkeryScopedCallsChecker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.name.CallableId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/mokkery/plugin/diagnostics/MokkeryCallsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "mock", "Lorg/jetbrains/kotlin/name/CallableId;", "mockMany", "spy", "every", "everySuspend", "verify", "verifySuspend", "validationMode", "Ldev/mokkery/plugin/core/MembersValidationMode;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "mokkery-plugin"})
public final class MokkeryCallsChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final CallableId mock;
    @NotNull
    private final CallableId mockMany;
    @NotNull
    private final CallableId spy;
    @NotNull
    private final CallableId every;
    @NotNull
    private final CallableId everySuspend;
    @NotNull
    private final CallableId verify;
    @NotNull
    private final CallableId verifySuspend;
    @NotNull
    private final MembersValidationMode validationMode;

    public MokkeryCallsChecker(@NotNull FirSession session, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(MppCheckerKind.Common);
        this.session = session;
        this.mock = Mokkery.Callable.INSTANCE.getMock();
        this.mockMany = Mokkery.Callable.INSTANCE.getMockMany();
        this.spy = Mokkery.Callable.INSTANCE.getSpy();
        this.every = Mokkery.Callable.INSTANCE.getEvery();
        this.everySuspend = Mokkery.Callable.INSTANCE.getEverySuspend();
        this.verify = Mokkery.Callable.INSTANCE.getVerify();
        this.verifySuspend = Mokkery.Callable.INSTANCE.getVerifySuspend();
        this.validationMode = MokkeryConfigApiKt.getValidationMode(configuration);
    }

    public void check(@NotNull FirFunctionCall expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirNamedReference firNamedReference = expression.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference = firNamedReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firNamedReference : null;
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference callee = firResolvedNamedReference;
        FirBasedSymbol firBasedSymbol = callee.getResolvedSymbol();
        FirNamedFunctionSymbol firNamedFunctionSymbol = firBasedSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firBasedSymbol : null;
        if (firNamedFunctionSymbol == null) {
            return;
        }
        FirNamedFunctionSymbol symbol = firNamedFunctionSymbol;
        firBasedSymbol = this.session;
        MembersValidationMode membersValidationMode = this.validationMode;
        MokkeryScopedCallsChecker scope = new MokkeryScopedCallsChecker((FirSession)firBasedSymbol, membersValidationMode, context, reporter, symbol);
        firBasedSymbol = symbol.getCallableId();
        if (Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.mock) || Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.spy)) {
            scope.checkInterception(expression);
        } else if (Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.mockMany)) {
            scope.checkManyInterceptions(expression);
        } else if (Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.every) || Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.everySuspend) || Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.verify) || Intrinsics.areEqual((Object)firBasedSymbol, (Object)this.verifySuspend)) {
            scope.checkTemplating(expression);
        }
    }
}

