/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.debug;

import dev.mokkery.debug.HierarchicalStringBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/mokkery/debug/JsonLikeStringBuilder;", "Ldev/mokkery/debug/HierarchicalStringBuilder;", "<init>", "()V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "", "nestedSectionCounter", "", "startSection", "", "headline", "line", "endSection", "build", "buildIndent", "i", "mokkery-runtime"})
final class JsonLikeStringBuilder
implements HierarchicalStringBuilder {
    @NotNull
    private final StringBuilder builder = new StringBuilder();
    @NotNull
    private String indent = "";
    private int nestedSectionCounter;

    @Override
    public void startSection(@NotNull String headline) {
        Intrinsics.checkNotNullParameter((Object)headline, (String)"headline");
        this.line(headline + " {");
        int n = this.nestedSectionCounter;
        this.nestedSectionCounter = n + 1;
        this.indent = this.buildIndent(this.nestedSectionCounter);
    }

    @Override
    public void line(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.builder.append(this.indent);
        this.builder.append(line);
        Intrinsics.checkNotNullExpressionValue((Object)this.builder.append('\n'), (String)"append(...)");
    }

    @Override
    public void endSection() {
        int n = this.nestedSectionCounter;
        this.nestedSectionCounter = n + -1;
        this.indent = this.buildIndent(this.nestedSectionCounter);
        this.line("}");
    }

    @Override
    @NotNull
    public String build() {
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String buildIndent(int i) {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence(JsonLikeStringBuilder::buildIndent$lambda$0), (int)i), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String buildIndent$lambda$0() {
        return "\t";
    }
}

