/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.templating;

import dev.mokkery.annotations.DelicateMokkeryApi;
import dev.mokkery.answering.autofill.AutofillProvider;
import dev.mokkery.answering.autofill.AutofillProviderKt;
import dev.mokkery.internal.ArrayUtilsKt;
import dev.mokkery.internal.ConcurrentTemplatingException;
import dev.mokkery.internal.MokkeryMockScope;
import dev.mokkery.internal.UtilsKt;
import dev.mokkery.internal.VarargsAmbiguityDetectedException;
import dev.mokkery.internal.matcher.ArgMatchersComposer;
import dev.mokkery.internal.signature.SignatureGenerator;
import dev.mokkery.internal.templating.CallTemplate;
import dev.mokkery.internal.templating.RawTemplateData;
import dev.mokkery.internal.templating.TemplatingInterceptor;
import dev.mokkery.internal.templating.TemplatingScope;
import dev.mokkery.internal.templating.TemplatingScopeDataBinder;
import dev.mokkery.internal.tracing.CallArg;
import dev.mokkery.matcher.ArgMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\n2\f\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001cH\u0016J\b\u0010%\u001a\u00020 H\u0016J-\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010'2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u001c2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0\u0011H\u0017\u00a2\u0006\u0002\u0010*J+\u0010+\u001a\u0002H'\"\u0004\b\u0000\u0010'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010,\u001a\u0002H'2\u0006\u0010-\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010.J+\u0010/\u001a\u0002H'\"\u0004\b\u0000\u0010'2\u0006\u0010!\u001a\u00020\"2\u0006\u00100\u001a\u0002012\u0006\u0010,\u001a\u0002H'H\u0016\u00a2\u0006\u0002\u00102J&\u00103\u001a\u00020 2\u0006\u00104\u001a\u0002012\u0006\u00100\u001a\u0002012\f\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0016J0\u00108\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u000201\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001109062\f\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006:"}, d2={"Ldev/mokkery/internal/templating/TemplatingScopeImpl;", "Ldev/mokkery/internal/templating/TemplatingScope;", "signatureGenerator", "Ldev/mokkery/internal/signature/SignatureGenerator;", "composer", "Ldev/mokkery/internal/matcher/ArgMatchersComposer;", "binder", "Ldev/mokkery/internal/templating/TemplatingScopeDataBinder;", "autofill", "Ldev/mokkery/answering/autofill/AutofillProvider;", "", "<init>", "(Ldev/mokkery/internal/signature/SignatureGenerator;Ldev/mokkery/internal/matcher/ArgMatchersComposer;Ldev/mokkery/internal/templating/TemplatingScopeDataBinder;Ldev/mokkery/answering/autofill/AutofillProvider;)V", "isReleased", "", "currentArgMatchers", "", "Ldev/mokkery/matcher/ArgMatcher;", "mocks", "", "Ldev/mokkery/internal/MokkeryMockScope;", "getMocks", "()Ljava/util/Set;", "templates", "Ldev/mokkery/internal/templating/CallTemplate;", "getTemplates", "()Ljava/util/List;", "currentGenericReturnTypeHint", "Lkotlin/reflect/KClass;", "getCurrentGenericReturnTypeHint", "()Lkotlin/reflect/KClass;", "ensureBinding", "", "token", "", "obj", "genericReturnTypeHint", "release", "matches", "T", "argType", "matcher", "(Lkotlin/reflect/KClass;Ldev/mokkery/matcher/ArgMatcher;)Ljava/lang/Object;", "interceptVarargElement", "arg", "isSpread", "(ILjava/lang/Object;Z)Ljava/lang/Object;", "interceptArg", "name", "", "(ILjava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "saveTemplate", "receiver", "args", "", "Ldev/mokkery/internal/tracing/CallArg;", "flush", "Lkotlin/Pair;", "mokkery-runtime"})
@SourceDebugExtension(value={"SMAP\nTemplatingScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplatingScope.kt\ndev/mokkery/internal/templating/TemplatingScopeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 AutofillProvider.kt\ndev/mokkery/answering/autofill/AutofillProviderKt\n+ 4 Utils.kt\ndev/mokkery/internal/UtilsKt\n*L\n1#1,135:1\n1863#2,2:136\n1872#2,3:143\n1557#2:146\n1628#2,3:147\n115#3:138\n115#3:141\n9#4:139\n9#4:140\n9#4:142\n*S KotlinDebug\n*F\n+ 1 TemplatingScope.kt\ndev/mokkery/internal/templating/TemplatingScopeImpl\n*L\n80#1:136,2\n101#1:143,3\n129#1:146\n129#1:147,3\n86#1:138\n88#1:141\n86#1:139\n87#1:140\n88#1:142\n*E\n"})
final class TemplatingScopeImpl
implements TemplatingScope {
    @NotNull
    private final SignatureGenerator signatureGenerator;
    @NotNull
    private final ArgMatchersComposer composer;
    @NotNull
    private final TemplatingScopeDataBinder binder;
    @NotNull
    private final AutofillProvider<Object> autofill;
    private boolean isReleased;
    @NotNull
    private final List<ArgMatcher<Object>> currentArgMatchers;
    @NotNull
    private final Set<MokkeryMockScope> mocks;
    @NotNull
    private final List<CallTemplate> templates;

    public TemplatingScopeImpl(@NotNull SignatureGenerator signatureGenerator, @NotNull ArgMatchersComposer composer, @NotNull TemplatingScopeDataBinder binder, @NotNull AutofillProvider<? extends Object> autofill) {
        Intrinsics.checkNotNullParameter((Object)signatureGenerator, (String)"signatureGenerator");
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        Intrinsics.checkNotNullParameter(autofill, (String)"autofill");
        this.signatureGenerator = signatureGenerator;
        this.composer = composer;
        this.binder = binder;
        this.autofill = autofill;
        this.currentArgMatchers = new ArrayList();
        this.mocks = new LinkedHashSet();
        this.templates = new ArrayList();
    }

    @Override
    @NotNull
    public Set<MokkeryMockScope> getMocks() {
        return this.mocks;
    }

    @Override
    @NotNull
    public List<CallTemplate> getTemplates() {
        return this.templates;
    }

    @Override
    @Nullable
    public KClass<?> getCurrentGenericReturnTypeHint() {
        return this.binder.firstProperlyBoundedData().getGenericReturnTypeHint();
    }

    @Override
    public void ensureBinding(int token, @Nullable Object obj, @Nullable KClass<?> genericReturnTypeHint) {
        if (this.isReleased) {
            return;
        }
        MokkeryMockScope mokkeryMockScope = this.binder.bind(token, obj);
        if (mokkeryMockScope == null) {
            return;
        }
        MokkeryMockScope scope = mokkeryMockScope;
        RawTemplateData rawTemplateData = this.binder.getDataFor(token);
        if (rawTemplateData != null) {
            rawTemplateData.setGenericReturnTypeHint(genericReturnTypeHint);
        }
        TemplatingInterceptor templating = scope.getInterceptor().getTemplating();
        if (templating.isEnabledWith(this)) {
            return;
        }
        if (templating.isEnabled()) {
            throw new ConcurrentTemplatingException();
        }
        this.getMocks().add(scope);
        templating.start(this);
    }

    @Override
    public void release() {
        this.isReleased = true;
        Iterable $this$forEach$iv = this.getMocks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MokkeryMockScope it = (MokkeryMockScope)element$iv;
            boolean bl = false;
            it.getInterceptor().getTemplating().stop();
        }
        this.getMocks().clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DelicateMokkeryApi
    public <T> T matches(@NotNull KClass<?> argType, @NotNull ArgMatcher<? super T> matcher) {
        void var3_4;
        Intrinsics.checkNotNullParameter(argType, (String)"argType");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        if (this.isReleased) {
            AutofillProvider<Object> $this$provideValue$iv = this.autofill;
            boolean $i$f$provideValue = false;
            Object $this$unsafeCast$iv = AutofillProviderKt.getIfProvided($this$provideValue$iv.provide(argType));
            boolean $i$f$unsafeCast = false;
            return (T)$this$unsafeCast$iv;
        }
        Object $this$unsafeCast$iv = matcher;
        boolean $i$f$unsafeCast = false;
        this.currentArgMatchers.add((ArgMatcher<Object>)$this$unsafeCast$iv);
        AutofillProvider<Object> $this$provideValue$iv = this.autofill;
        boolean $i$f$provideValue = false;
        $this$unsafeCast$iv = AutofillProviderKt.getIfProvided($this$provideValue$iv.provide(argType));
        $i$f$unsafeCast = false;
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T interceptVarargElement(int token, T arg, boolean isSpread) {
        List<Object> list;
        if (this.isReleased) {
            return arg;
        }
        RawTemplateData rawTemplateData = this.binder.getDataFor(token);
        if (rawTemplateData == null) {
            return arg;
        }
        RawTemplateData data = rawTemplateData;
        if (isSpread) {
            list = ArrayUtilsKt.asListOrNull(arg);
            if (list == null) {
                UtilsKt.mokkeryRuntimeError("Expected array, but " + arg + " encountered!");
                throw new KotlinNothingValueException();
            }
        } else {
            list = CollectionsKt.listOf(arg);
        }
        List<Object> args = list;
        int size = args.size();
        int elementMatchersSize = UtilsKt.subListAfter(this.currentArgMatchers, data.getVarargMatchersCount()).size();
        if (elementMatchersSize != 0 && elementMatchersSize < size) {
            throw new VarargsAmbiguityDetectedException();
        }
        Iterable $this$forEachIndexed$iv = args;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void vararg;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int index = n;
            boolean bl = false;
            Object object = (ArgMatcher)CollectionsKt.getOrNull(this.currentArgMatchers, (int)(data.getVarargMatchersCount() + index));
            if (object != null) continue;
            object = this.currentArgMatchers.add(new ArgMatcher.Equals<void>(vararg));
        }
        data.setVarargMatchersCount(data.getVarargMatchersCount() + elementMatchersSize);
        return arg;
    }

    @Override
    public <T> T interceptArg(int token, @NotNull String name, T arg) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.isReleased) {
            return arg;
        }
        RawTemplateData rawTemplateData = this.binder.getDataFor(token);
        if (rawTemplateData == null) {
            return arg;
        }
        RawTemplateData data = rawTemplateData;
        data.getMatchers().put(name, CollectionsKt.toMutableList((Collection)this.currentArgMatchers));
        this.currentArgMatchers.clear();
        return arg;
    }

    @Override
    public void saveTemplate(@NotNull String receiver, @NotNull String name, @NotNull List<CallArg> args) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        if (this.isReleased) {
            return;
        }
        List<Pair<String, ArgMatcher<Object>>> matchers = this.flush(args);
        ((Collection)this.getTemplates()).add(new CallTemplate(receiver, name, this.signatureGenerator.generate(name, args), MapsKt.toMap((Iterable)matchers)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, ArgMatcher<Object>>> flush(List<CallArg> args) {
        void $this$mapTo$iv$iv;
        Map namedMatchers = MapsKt.toMutableMap(this.binder.firstProperlyBoundedData().getMatchers());
        this.currentArgMatchers.clear();
        this.binder.reset();
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CallArg callArg = (CallArg)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list = (List)namedMatchers.get(it.getName());
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List matchers = list;
            collection.add(TuplesKt.to((Object)it.getName(), this.composer.compose((CallArg)it, matchers)));
        }
        return (List)destination$iv$iv;
    }
}

