/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.tracing;

import dev.mokkery.internal.CallContext;
import dev.mokkery.internal.Counter;
import dev.mokkery.internal.MokkeryToken;
import dev.mokkery.internal.tracing.CallTrace;
import dev.mokkery.internal.tracing.CallTracingInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u0005*\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006\""}, d2={"Ldev/mokkery/internal/tracing/CallTracingInterceptorImpl;", "Ldev/mokkery/internal/tracing/CallTracingInterceptor;", "", "reset", "()V", "Ldev/mokkery/internal/tracing/CallTrace;", "trace", "markVerified", "(Ldev/mokkery/internal/tracing/CallTrace;)V", "Ldev/mokkery/internal/CallContext;", "context", "", "interceptCall", "(Ldev/mokkery/internal/CallContext;)Ljava/lang/Object;", "toTrace", "(Ldev/mokkery/internal/CallContext;)Ldev/mokkery/internal/tracing/CallTrace;", "Ldev/mokkery/internal/Counter;", "counter", "Ldev/mokkery/internal/Counter;", "", "verified", "Ljava/util/List;", "_all", "Ljava/util/concurrent/locks/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "", "getUnverified", "()Ljava/util/List;", "unverified", "getAll", "all", "<init>", "(Ldev/mokkery/internal/Counter;)V", "mokkery-runtime"})
@SourceDebugExtension(value={"SMAP\nCallTracingInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTracingInterceptor.kt\ndev/mokkery/internal/tracing/CallTracingInterceptorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
final class CallTracingInterceptorImpl
implements CallTracingInterceptor {
    @NotNull
    private final Counter counter;
    @NotNull
    private final List<CallTrace> verified;
    @NotNull
    private final List<CallTrace> _all;
    @NotNull
    private final ReentrantLock lock;

    public CallTracingInterceptorImpl(@NotNull Counter counter) {
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        this.counter = counter;
        this.verified = new ArrayList();
        this._all = new ArrayList();
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CallTrace> getUnverified() {
        List list;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            list = CollectionsKt.minus((Iterable)this._all, (Iterable)CollectionsKt.toSet((Iterable)this.verified));
        }
        finally {
            reentrantLock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<CallTrace> getAll() {
        List list;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            list = CollectionsKt.toMutableList((Collection)this._all);
        }
        finally {
            reentrantLock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            this.verified.clear();
            this._all.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markVerified(@NotNull CallTrace trace) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            ((Collection)this.verified).add(trace);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Object interceptCall(@NotNull CallContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            ((Collection)this._all).add(this.toTrace(context));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
        return MokkeryToken.CallNext.INSTANCE;
    }

    private final CallTrace toTrace(CallContext $this$toTrace) {
        return new CallTrace($this$toTrace.getScope().getId(), $this$toTrace.getName(), $this$toTrace.getArgs(), this.counter.next());
    }

    @Override
    @Nullable
    public Object interceptSuspendCall(@NotNull CallContext context, @NotNull Continuation<Object> $completion) {
        return CallTracingInterceptor.DefaultImpls.interceptSuspendCall(this, context, $completion);
    }
}

