package dev.mokkery.internal.verify

import dev.mokkery.internal.utils.failAssertion
import dev.mokkery.internal.calls.CallMatcher
import dev.mokkery.internal.calls.isMatching
import dev.mokkery.internal.render.Renderer
import dev.mokkery.internal.calls.CallTemplate
import dev.mokkery.internal.calls.CallTrace
import dev.mokkery.internal.context.GlobalMokkeryContext
import dev.mokkery.internal.context.tools
import dev.mokkery.internal.verify.results.TemplateGroupedMatchingResults
import dev.mokkery.internal.verify.render.TemplateGroupedMatchingResultsRenderer
import dev.mokkery.internal.verify.render.UnverifiedCallsRenderer

internal class ExhaustiveSoftVerifier(
    private val callMatcher: CallMatcher = GlobalMokkeryContext.tools.callMatcher,
    private val matchingResultsRenderer: Renderer<TemplateGroupedMatchingResults> = TemplateGroupedMatchingResultsRenderer(),
    private val unverifiedCallsRenderer: Renderer<List<CallTrace>> = UnverifiedCallsRenderer()
) : Verifier {

    override fun verify(callTraces: List<CallTrace>, callTemplates: List<CallTemplate>): List<CallTrace> {
        val unverifiedCalls = callTraces.toMutableList()
        callTemplates.forEach { template ->
            val matching = callTraces.filter { callMatcher.match(it, template).isMatching }
            if (matching.isEmpty()) {
                failAssertion {
                    appendLine("No matching call for $template!")
                    val results = TemplateGroupedMatchingResults(
                        template = template,
                        calls = callTraces.groupBy { callMatcher.match(it, template) }
                    )
                    append(matchingResultsRenderer.render(results))
                }
            }
            unverifiedCalls.removeAll(matching.toSet())
        }
        if (unverifiedCalls.isNotEmpty()) {
            failAssertion {
                append(unverifiedCallsRenderer.render(unverifiedCalls))
            }
        }
        return callTraces
    }
}
