/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.calls;

import dev.mokkery.context.CallArgument;
import dev.mokkery.internal.utils.UtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0080\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\rJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J>\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010\rR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001e\u001a\u0004\b \u0010\rR\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010!\u001a\u0004\b\"\u0010\u0012R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010#\u001a\u0004\b$\u0010\u0014\u00a8\u0006%"}, d2={"Ldev/mokkery/internal/calls/CallTrace;", "", "", "receiver", "name", "", "Ldev/mokkery/context/CallArgument;", "args", "", "orderStamp", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;J)V", "toString", "()Ljava/lang/String;", "toStringNoReceiver", "component1", "component2", "component3", "()Ljava/util/List;", "component4", "()J", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;J)Ldev/mokkery/internal/calls/CallTrace;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/lang/String;", "getReceiver", "getName", "Ljava/util/List;", "getArgs", "J", "getOrderStamp", "mokkery-runtime"})
public final class CallTrace {
    @NotNull
    private final String receiver;
    @NotNull
    private final String name;
    @NotNull
    private final List<CallArgument> args;
    private final long orderStamp;

    public CallTrace(@NotNull String receiver, @NotNull String name, @NotNull List<CallArgument> args, long orderStamp) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.receiver = receiver;
        this.name = name;
        this.args = args;
        this.orderStamp = orderStamp;
    }

    @NotNull
    public final String getReceiver() {
        return this.receiver;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<CallArgument> getArgs() {
        return this.args;
    }

    public final long getOrderStamp() {
        return this.orderStamp;
    }

    @NotNull
    public String toString() {
        return UtilsKt.callToString(this.receiver, this.name, this.args);
    }

    @NotNull
    public final String toStringNoReceiver() {
        return UtilsKt.callFunctionToString(this.name, this.args);
    }

    @NotNull
    public final String component1() {
        return this.receiver;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final List<CallArgument> component3() {
        return this.args;
    }

    public final long component4() {
        return this.orderStamp;
    }

    @NotNull
    public final CallTrace copy(@NotNull String receiver, @NotNull String name, @NotNull List<CallArgument> args, long orderStamp) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return new CallTrace(receiver, name, args, orderStamp);
    }

    public static /* synthetic */ CallTrace copy$default(CallTrace callTrace, String string, String string2, List list, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = callTrace.receiver;
        }
        if ((n & 2) != 0) {
            string2 = callTrace.name;
        }
        if ((n & 4) != 0) {
            list = callTrace.args;
        }
        if ((n & 8) != 0) {
            l = callTrace.orderStamp;
        }
        return callTrace.copy(string, string2, list, l);
    }

    public int hashCode() {
        int result = this.receiver.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + ((Object)this.args).hashCode();
        result = result * 31 + Long.hashCode(this.orderStamp);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CallTrace)) {
            return false;
        }
        CallTrace callTrace = (CallTrace)other;
        if (!Intrinsics.areEqual((Object)this.receiver, (Object)callTrace.receiver)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)callTrace.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.args, callTrace.args)) {
            return false;
        }
        return this.orderStamp == callTrace.orderStamp;
    }
}

