/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.calls;

import dev.mokkery.annotations.DelicateMokkeryApi;
import dev.mokkery.answering.autofill.AutofillProvider;
import dev.mokkery.answering.autofill.AutofillProviderKt;
import dev.mokkery.context.CallArgument;
import dev.mokkery.context.Function;
import dev.mokkery.internal.ConcurrentTemplatingException;
import dev.mokkery.internal.MokkeryMockInstance;
import dev.mokkery.internal.VarargsAmbiguityDetectedException;
import dev.mokkery.internal.calls.ArgMatchersComposer;
import dev.mokkery.internal.calls.CallTemplate;
import dev.mokkery.internal.calls.RawTemplateData;
import dev.mokkery.internal.calls.TemplatingScope;
import dev.mokkery.internal.calls.TemplatingScopeDataBinder;
import dev.mokkery.internal.interceptor.TemplatingInterceptor;
import dev.mokkery.internal.names.SignatureGenerator;
import dev.mokkery.internal.utils.ArrayUtilsKt;
import dev.mokkery.internal.utils.UtilsKt;
import dev.mokkery.matcher.ArgMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u001b\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cJ-\u0010 \u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J-\u0010$\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b$\u0010%J-\u0010*\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016\u00a2\u0006\u0004\b*\u0010+J7\u0010-\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\"\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00190,0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002\u00a2\u0006\u0004\b-\u0010.R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010/R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00100R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00101R\u001c\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u00102R\u0016\u00103\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\"\u00106\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0019058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R \u0010:\u001a\b\u0012\u0004\u0012\u000209088\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R \u0010?\u001a\b\u0012\u0004\u0012\u00020>058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b?\u00107\u001a\u0004\b@\u0010AR\u001a\u0010D\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006E"}, d2={"Ldev/mokkery/internal/calls/TemplatingScopeImpl;", "Ldev/mokkery/internal/calls/TemplatingScope;", "Ldev/mokkery/internal/names/SignatureGenerator;", "signatureGenerator", "Ldev/mokkery/internal/calls/ArgMatchersComposer;", "composer", "Ldev/mokkery/internal/calls/TemplatingScopeDataBinder;", "binder", "Ldev/mokkery/answering/autofill/AutofillProvider;", "", "autofill", "<init>", "(Ldev/mokkery/internal/names/SignatureGenerator;Ldev/mokkery/internal/calls/ArgMatchersComposer;Ldev/mokkery/internal/calls/TemplatingScopeDataBinder;Ldev/mokkery/answering/autofill/AutofillProvider;)V", "", "token", "obj", "Lkotlin/reflect/KClass;", "genericReturnTypeHint", "", "ensureBinding", "(ILjava/lang/Object;Lkotlin/reflect/KClass;)V", "release", "()V", "T", "argType", "Ldev/mokkery/matcher/ArgMatcher;", "matcher", "matches", "(Lkotlin/reflect/KClass;Ldev/mokkery/matcher/ArgMatcher;)Ljava/lang/Object;", "arg", "", "isSpread", "interceptVarargElement", "(ILjava/lang/Object;Z)Ljava/lang/Object;", "", "name", "interceptArg", "(ILjava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "receiver", "", "Ldev/mokkery/context/CallArgument;", "args", "saveTemplate", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "Lkotlin/Pair;", "flush", "(Ljava/util/List;)Ljava/util/List;", "Ldev/mokkery/internal/names/SignatureGenerator;", "Ldev/mokkery/internal/calls/ArgMatchersComposer;", "Ldev/mokkery/internal/calls/TemplatingScopeDataBinder;", "Ldev/mokkery/answering/autofill/AutofillProvider;", "isReleased", "Z", "", "currentArgMatchers", "Ljava/util/List;", "", "Ldev/mokkery/internal/MokkeryMockInstance;", "mocks", "Ljava/util/Set;", "getMocks", "()Ljava/util/Set;", "Ldev/mokkery/internal/calls/CallTemplate;", "templates", "getTemplates", "()Ljava/util/List;", "getCurrentGenericReturnTypeHint", "()Lkotlin/reflect/KClass;", "currentGenericReturnTypeHint", "mokkery-runtime"})
@SourceDebugExtension(value={"SMAP\nTemplatingScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplatingScope.kt\ndev/mokkery/internal/calls/TemplatingScopeImpl\n+ 2 Utils.jvm.kt\ndev/mokkery/internal/utils/Utils_jvmKt\n+ 3 MokkeryInstance.kt\ndev/mokkery/internal/MokkeryInstanceKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 AutofillProvider.kt\ndev/mokkery/answering/autofill/AutofillProviderKt\n+ 6 Utils.kt\ndev/mokkery/internal/utils/UtilsKt\n*L\n1#1,140:1\n9#2:141\n9#2:146\n37#3:142\n37#3:144\n1863#4:143\n1864#4:145\n1872#4,3:152\n1557#4:155\n1628#4,3:156\n113#5:147\n113#5:150\n9#6:148\n9#6:149\n9#6:151\n*S KotlinDebug\n*F\n+ 1 TemplatingScope.kt\ndev/mokkery/internal/calls/TemplatingScopeImpl\n*L\n68#1:141\n89#1:146\n69#1:142\n82#1:144\n82#1:143\n82#1:145\n105#1:152,3\n133#1:155\n133#1:156,3\n90#1:147\n92#1:150\n90#1:148\n91#1:149\n92#1:151\n*E\n"})
final class TemplatingScopeImpl
implements TemplatingScope {
    @NotNull
    private final SignatureGenerator signatureGenerator;
    @NotNull
    private final ArgMatchersComposer composer;
    @NotNull
    private final TemplatingScopeDataBinder binder;
    @NotNull
    private final AutofillProvider<Object> autofill;
    private boolean isReleased;
    @NotNull
    private final List<ArgMatcher<Object>> currentArgMatchers;
    @NotNull
    private final Set<MokkeryMockInstance> mocks;
    @NotNull
    private final List<CallTemplate> templates;

    public TemplatingScopeImpl(@NotNull SignatureGenerator signatureGenerator, @NotNull ArgMatchersComposer composer, @NotNull TemplatingScopeDataBinder binder, @NotNull AutofillProvider<? extends Object> autofill) {
        Intrinsics.checkNotNullParameter((Object)signatureGenerator, (String)"signatureGenerator");
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        Intrinsics.checkNotNullParameter(autofill, (String)"autofill");
        this.signatureGenerator = signatureGenerator;
        this.composer = composer;
        this.binder = binder;
        this.autofill = autofill;
        this.currentArgMatchers = new ArrayList();
        this.mocks = new LinkedHashSet();
        this.templates = new ArrayList();
    }

    @Override
    @NotNull
    public Set<MokkeryMockInstance> getMocks() {
        return this.mocks;
    }

    @Override
    @NotNull
    public List<CallTemplate> getTemplates() {
        return this.templates;
    }

    @Override
    @Nullable
    public KClass<?> getCurrentGenericReturnTypeHint() {
        return this.binder.firstProperlyBoundedData().getGenericReturnTypeHint();
    }

    @Override
    public void ensureBinding(int token, @Nullable Object obj, @Nullable KClass<?> genericReturnTypeHint) {
        if (this.isReleased) {
            return;
        }
        MokkeryMockInstance mokkeryMockInstance = this.binder.bind(token, obj);
        if (mokkeryMockInstance == null) {
            return;
        }
        MokkeryMockInstance scope = mokkeryMockInstance;
        RawTemplateData rawTemplateData = this.binder.getDataFor(token);
        if (rawTemplateData != null) {
            KClass<?> kClass;
            KClass<?> kClass2 = genericReturnTypeHint;
            if (kClass2 != null) {
                KClass<?> $this$takeIfImplementedOrAny$iv = kClass2;
                boolean $i$f$takeIfImplementedOrAny = false;
                kClass = $this$takeIfImplementedOrAny$iv;
            } else {
                kClass = null;
            }
            rawTemplateData.setGenericReturnTypeHint(kClass);
        }
        MokkeryMockInstance $this$interceptor$iv = scope;
        boolean $i$f$getInterceptor = false;
        TemplatingInterceptor templating = $this$interceptor$iv.get_mokkeryInterceptor().getTemplating();
        if (templating.isEnabledWith(this)) {
            return;
        }
        if (templating.isEnabled()) {
            throw new ConcurrentTemplatingException();
        }
        this.getMocks().add(scope);
        templating.start(this);
    }

    @Override
    public void release() {
        this.isReleased = true;
        Iterable $this$forEach$iv = this.getMocks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MokkeryMockInstance it = (MokkeryMockInstance)element$iv;
            boolean bl = false;
            MokkeryMockInstance $this$interceptor$iv = it;
            boolean $i$f$getInterceptor = false;
            $this$interceptor$iv.get_mokkeryInterceptor().getTemplating().stop();
        }
        this.getMocks().clear();
    }

    @Override
    @DelicateMokkeryApi
    public <T> T matches(@NotNull KClass<?> argType, @NotNull ArgMatcher<? super T> matcher) {
        ArgMatcher<? super T> $this$unsafeCast$iv;
        boolean $i$f$unsafeCast;
        boolean $i$f$provideValue;
        Object $this$provideValue$iv;
        Intrinsics.checkNotNullParameter(argType, (String)"argType");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        KClass<?> $this$takeIfImplementedOrAny$iv = argType;
        boolean $i$f$takeIfImplementedOrAny = false;
        KClass<?> safeKClass = $this$takeIfImplementedOrAny$iv;
        if (this.isReleased) {
            $this$provideValue$iv = this.autofill;
            $i$f$provideValue = false;
            $this$provideValue$iv = AutofillProviderKt.getIfProvided($this$provideValue$iv.provide(safeKClass));
            $i$f$unsafeCast = false;
            return (T)$this$unsafeCast$iv;
        }
        $this$unsafeCast$iv = matcher;
        $i$f$unsafeCast = false;
        this.currentArgMatchers.add((ArgMatcher<Object>)$this$unsafeCast$iv);
        $this$provideValue$iv = this.autofill;
        $i$f$provideValue = false;
        $this$provideValue$iv = AutofillProviderKt.getIfProvided($this$provideValue$iv.provide(safeKClass));
        $i$f$unsafeCast = false;
        return (T)$this$unsafeCast$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T interceptVarargElement(int token, T arg, boolean isSpread) {
        List<Object> list;
        if (this.isReleased) {
            return arg;
        }
        RawTemplateData rawTemplateData = this.binder.getDataFor(token);
        if (rawTemplateData == null) {
            return arg;
        }
        RawTemplateData data = rawTemplateData;
        if (isSpread) {
            list = ArrayUtilsKt.asListOrNull(arg);
            if (list == null) {
                UtilsKt.mokkeryRuntimeError("Expected array, but " + arg + " encountered!");
                throw new KotlinNothingValueException();
            }
        } else {
            list = CollectionsKt.listOf(arg);
        }
        List<Object> args = list;
        int size = args.size();
        int elementMatchersSize = UtilsKt.subListAfter(this.currentArgMatchers, data.getVarargMatchersCount()).size();
        if (elementMatchersSize != 0 && elementMatchersSize < size) {
            throw new VarargsAmbiguityDetectedException();
        }
        Iterable $this$forEachIndexed$iv = args;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void vararg;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int index = n;
            boolean bl = false;
            Object object = (ArgMatcher)CollectionsKt.getOrNull(this.currentArgMatchers, (int)(data.getVarargMatchersCount() + index));
            if (object != null) continue;
            object = this.currentArgMatchers.add(new ArgMatcher.Equals<void>(vararg));
        }
        data.setVarargMatchersCount(data.getVarargMatchersCount() + elementMatchersSize);
        return arg;
    }

    @Override
    public <T> T interceptArg(int token, @NotNull String name, T arg) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.isReleased) {
            return arg;
        }
        RawTemplateData rawTemplateData = this.binder.getDataFor(token);
        if (rawTemplateData == null) {
            return arg;
        }
        RawTemplateData data = rawTemplateData;
        data.getMatchers().put(name, CollectionsKt.toMutableList((Collection)this.currentArgMatchers));
        this.currentArgMatchers.clear();
        return arg;
    }

    @Override
    public void saveTemplate(@NotNull String receiver, @NotNull String name, @NotNull List<CallArgument> args) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        if (this.isReleased) {
            return;
        }
        List<Pair<String, ArgMatcher<Object>>> matchers = this.flush(args);
        ((Collection)this.getTemplates()).add(new CallTemplate(receiver, name, this.signatureGenerator.generate(name, args), MapsKt.toMap((Iterable)matchers)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, ArgMatcher<Object>>> flush(List<CallArgument> args) {
        void $this$mapTo$iv$iv;
        Map namedMatchers = MapsKt.toMutableMap(this.binder.firstProperlyBoundedData().getMatchers());
        this.currentArgMatchers.clear();
        this.binder.reset();
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CallArgument callArgument = (CallArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Function.Parameter param = it.getParameter();
            List list = (List)namedMatchers.get(param.getName());
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List matchers = list;
            collection.add(TuplesKt.to((Object)param.getName(), this.composer.compose((CallArgument)it, matchers)));
        }
        return (List)destination$iv$iv;
    }
}

