/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.verify;

import dev.mokkery.internal.calls.CallMatchResult;
import dev.mokkery.internal.calls.CallMatcher;
import dev.mokkery.internal.calls.CallTemplate;
import dev.mokkery.internal.calls.CallTrace;
import dev.mokkery.internal.context.GlobalMokkeryContextKt;
import dev.mokkery.internal.context.MokkeryToolsKt;
import dev.mokkery.internal.render.Renderer;
import dev.mokkery.internal.utils.AssertionKt;
import dev.mokkery.internal.verify.Verifier;
import dev.mokkery.internal.verify.render.TemplateMatchingResultsRenderer;
import dev.mokkery.internal.verify.results.TemplateMatchingResult;
import dev.mokkery.internal.verify.results.TemplateMatchingResultsComposer;
import dev.mokkery.internal.verify.results.TemplateMatchingResultsComposerKt;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B1\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ1\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0015\u001a\u00020\u0014*\u00060\u0012j\u0002`\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J3\u0010\u0017\u001a\u00020\u0014*\u00060\u0012j\u0002`\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR \u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001b\u00a8\u0006\u001c"}, d2={"Ldev/mokkery/internal/verify/ExhaustiveOrderVerifier;", "Ldev/mokkery/internal/verify/Verifier;", "Ldev/mokkery/internal/calls/CallMatcher;", "callMatcher", "Ldev/mokkery/internal/verify/results/TemplateMatchingResultsComposer;", "resultsComposer", "Ldev/mokkery/internal/render/Renderer;", "", "Ldev/mokkery/internal/verify/results/TemplateMatchingResult;", "renderer", "<init>", "(Ldev/mokkery/internal/calls/CallMatcher;Ldev/mokkery/internal/verify/results/TemplateMatchingResultsComposer;Ldev/mokkery/internal/render/Renderer;)V", "Ldev/mokkery/internal/calls/CallTrace;", "callTraces", "Ldev/mokkery/internal/calls/CallTemplate;", "callTemplates", "verify", "(Ljava/util/List;Ljava/util/List;)Ljava/util/List;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "appendMainError", "(Ljava/lang/StringBuilder;)V", "appendRenderedResults", "(Ljava/lang/StringBuilder;Ljava/util/List;Ljava/util/List;)V", "Ldev/mokkery/internal/calls/CallMatcher;", "Ldev/mokkery/internal/verify/results/TemplateMatchingResultsComposer;", "Ldev/mokkery/internal/render/Renderer;", "mokkery-runtime"})
@SourceDebugExtension(value={"SMAP\nExhaustiveOrderVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExhaustiveOrderVerifier.kt\ndev/mokkery/internal/verify/ExhaustiveOrderVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CallMatcher.kt\ndev/mokkery/internal/calls/CallMatcherKt\n*L\n1#1,48:1\n1863#2:49\n1864#2:51\n18#3:50\n*S KotlinDebug\n*F\n+ 1 ExhaustiveOrderVerifier.kt\ndev/mokkery/internal/verify/ExhaustiveOrderVerifier\n*L\n28#1:49\n28#1:51\n29#1:50\n*E\n"})
public final class ExhaustiveOrderVerifier
implements Verifier {
    @NotNull
    private final CallMatcher callMatcher;
    @NotNull
    private final TemplateMatchingResultsComposer resultsComposer;
    @NotNull
    private final Renderer<List<? extends TemplateMatchingResult>> renderer;

    public ExhaustiveOrderVerifier(@NotNull CallMatcher callMatcher, @NotNull TemplateMatchingResultsComposer resultsComposer, @NotNull Renderer<? super List<? extends TemplateMatchingResult>> renderer) {
        Intrinsics.checkNotNullParameter((Object)callMatcher, (String)"callMatcher");
        Intrinsics.checkNotNullParameter((Object)resultsComposer, (String)"resultsComposer");
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        this.callMatcher = callMatcher;
        this.resultsComposer = resultsComposer;
        this.renderer = renderer;
    }

    public /* synthetic */ ExhaustiveOrderVerifier(CallMatcher callMatcher, TemplateMatchingResultsComposer templateMatchingResultsComposer, Renderer renderer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            callMatcher = MokkeryToolsKt.getTools(GlobalMokkeryContextKt.getGlobalMokkeryContext()).getCallMatcher();
        }
        if ((n & 2) != 0) {
            templateMatchingResultsComposer = TemplateMatchingResultsComposerKt.TemplateMatchingResultsComposer(callMatcher);
        }
        if ((n & 4) != 0) {
            renderer = new TemplateMatchingResultsRenderer(null, null, 3, null);
        }
        this(callMatcher, templateMatchingResultsComposer, renderer);
    }

    @Override
    @NotNull
    public List<CallTrace> verify(@NotNull List<CallTrace> callTraces, @NotNull List<CallTemplate> callTemplates) {
        Intrinsics.checkNotNullParameter(callTraces, (String)"callTraces");
        Intrinsics.checkNotNullParameter(callTemplates, (String)"callTemplates");
        if (callTemplates.size() != callTraces.size()) {
            AssertionKt.failAssertion((Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> ExhaustiveOrderVerifier.verify$lambda$0(this, callTraces, callTemplates, arg_0)));
            throw new KotlinNothingValueException();
        }
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)callTraces, (Iterable)callTemplates);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            CallTrace trace = (CallTrace)pair.component1();
            CallTemplate template = (CallTemplate)pair.component2();
            CallMatchResult $this$isNotMatching$iv = this.callMatcher.match(trace, template);
            boolean $i$f$isNotMatching = false;
            if (!($this$isNotMatching$iv != CallMatchResult.Matching)) continue;
            AssertionKt.failAssertion((Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> ExhaustiveOrderVerifier.verify$lambda$2$lambda$1(this, callTraces, callTemplates, arg_0)));
            throw new KotlinNothingValueException();
        }
        return callTraces;
    }

    private final void appendMainError(StringBuilder $this$appendMainError) {
        StringBuilder stringBuilder = $this$appendMainError.append("Expected strict order of calls without unverified ones, but not satisfied!");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
    }

    private final void appendRenderedResults(StringBuilder $this$appendRenderedResults, List<CallTrace> callTraces, List<CallTemplate> callTemplates) {
        List<TemplateMatchingResult> results = this.resultsComposer.compose(callTraces, callTemplates);
        $this$appendRenderedResults.append(this.renderer.render(results));
    }

    private static final Unit verify$lambda$0(ExhaustiveOrderVerifier this$0, List $callTraces, List $callTemplates, StringBuilder $this$failAssertion) {
        Intrinsics.checkNotNullParameter((Object)$this$failAssertion, (String)"$this$failAssertion");
        this$0.appendMainError($this$failAssertion);
        this$0.appendRenderedResults($this$failAssertion, $callTraces, $callTemplates);
        return Unit.INSTANCE;
    }

    private static final Unit verify$lambda$2$lambda$1(ExhaustiveOrderVerifier this$0, List $callTraces, List $callTemplates, StringBuilder $this$failAssertion) {
        Intrinsics.checkNotNullParameter((Object)$this$failAssertion, (String)"$this$failAssertion");
        this$0.appendMainError($this$failAssertion);
        this$0.appendRenderedResults($this$failAssertion, $callTraces, $callTemplates);
        return Unit.INSTANCE;
    }

    public ExhaustiveOrderVerifier() {
        this(null, null, null, 7, null);
    }
}

