/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.verify;

import dev.mokkery.internal.calls.CallMatchResult;
import dev.mokkery.internal.calls.CallMatcher;
import dev.mokkery.internal.calls.CallTemplate;
import dev.mokkery.internal.calls.CallTrace;
import dev.mokkery.internal.context.GlobalMokkeryContextKt;
import dev.mokkery.internal.context.MokkeryToolsKt;
import dev.mokkery.internal.render.Renderer;
import dev.mokkery.internal.utils.AssertionKt;
import dev.mokkery.internal.verify.Verifier;
import dev.mokkery.internal.verify.render.TemplateMatchingResultsRenderer;
import dev.mokkery.internal.verify.results.TemplateMatchingResult;
import dev.mokkery.internal.verify.results.TemplateMatchingResultsComposer;
import dev.mokkery.internal.verify.results.TemplateMatchingResultsComposerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B1\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ1\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0018\u001a\u00020\u0017*\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J3\u0010\u001a\u001a\u00020\u0017*\u00060\u0012j\u0002`\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001dR \u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001e\u00a8\u0006\u001f"}, d2={"Ldev/mokkery/internal/verify/OrderVerifier;", "Ldev/mokkery/internal/verify/Verifier;", "Ldev/mokkery/internal/calls/CallMatcher;", "callMatcher", "Ldev/mokkery/internal/verify/results/TemplateMatchingResultsComposer;", "resultsComposer", "Ldev/mokkery/internal/render/Renderer;", "", "Ldev/mokkery/internal/verify/results/TemplateMatchingResult;", "renderer", "<init>", "(Ldev/mokkery/internal/calls/CallMatcher;Ldev/mokkery/internal/verify/results/TemplateMatchingResultsComposer;Ldev/mokkery/internal/render/Renderer;)V", "Ldev/mokkery/internal/calls/CallTrace;", "callTraces", "Ldev/mokkery/internal/calls/CallTemplate;", "callTemplates", "verify", "(Ljava/util/List;Ljava/util/List;)Ljava/util/List;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "template", "", "templateIndex", "", "appendMainError", "(Ljava/lang/StringBuilder;Ldev/mokkery/internal/calls/CallTemplate;I)V", "appendRenderedResults", "(Ljava/lang/StringBuilder;Ljava/util/List;Ljava/util/List;)V", "Ldev/mokkery/internal/calls/CallMatcher;", "Ldev/mokkery/internal/verify/results/TemplateMatchingResultsComposer;", "Ldev/mokkery/internal/render/Renderer;", "mokkery-runtime"})
@SourceDebugExtension(value={"SMAP\nOrderVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderVerifier.kt\ndev/mokkery/internal/verify/OrderVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CallMatcher.kt\ndev/mokkery/internal/calls/CallMatcherKt\n*L\n1#1,51:1\n1872#2,2:52\n360#2,3:54\n363#2,4:58\n1874#2:62\n15#3:57\n*S KotlinDebug\n*F\n+ 1 OrderVerifier.kt\ndev/mokkery/internal/verify/OrderVerifier\n*L\n24#1:52,2\n25#1:54,3\n25#1:58,4\n24#1:62\n25#1:57\n*E\n"})
public final class OrderVerifier
implements Verifier {
    @NotNull
    private final CallMatcher callMatcher;
    @NotNull
    private final TemplateMatchingResultsComposer resultsComposer;
    @NotNull
    private final Renderer<List<? extends TemplateMatchingResult>> renderer;

    public OrderVerifier(@NotNull CallMatcher callMatcher, @NotNull TemplateMatchingResultsComposer resultsComposer, @NotNull Renderer<? super List<? extends TemplateMatchingResult>> renderer) {
        Intrinsics.checkNotNullParameter((Object)callMatcher, (String)"callMatcher");
        Intrinsics.checkNotNullParameter((Object)resultsComposer, (String)"resultsComposer");
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        this.callMatcher = callMatcher;
        this.resultsComposer = resultsComposer;
        this.renderer = renderer;
    }

    public /* synthetic */ OrderVerifier(CallMatcher callMatcher, TemplateMatchingResultsComposer templateMatchingResultsComposer, Renderer renderer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            callMatcher = MokkeryToolsKt.getTools(GlobalMokkeryContextKt.getGlobalMokkeryContext()).getCallMatcher();
        }
        if ((n & 2) != 0) {
            templateMatchingResultsComposer = TemplateMatchingResultsComposerKt.TemplateMatchingResultsComposer(callMatcher);
        }
        if ((n & 4) != 0) {
            renderer = new TemplateMatchingResultsRenderer(null, null, 3, null);
        }
        this(callMatcher, templateMatchingResultsComposer, renderer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CallTrace> verify(@NotNull List<CallTrace> callTraces, @NotNull List<CallTemplate> callTemplates) {
        Intrinsics.checkNotNullParameter(callTraces, (String)"callTraces");
        Intrinsics.checkNotNullParameter(callTemplates, (String)"callTemplates");
        List currentTraces = null;
        currentTraces = CollectionsKt.toMutableList((Collection)callTraces);
        List verifiedTraces = new ArrayList();
        Iterable $this$forEachIndexed$iv = callTemplates;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int matchingTraceIndex;
            void template;
            int templateIndex;
            block5: {
                int n;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                CallTemplate callTemplate = (CallTemplate)item$iv;
                templateIndex = n2;
                boolean bl = false;
                List $this$indexOfFirst$iv = currentTraces;
                boolean $i$f$indexOfFirst = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$indexOfFirst$iv) {
                    CallTrace it = (CallTrace)item$iv2;
                    boolean bl2 = false;
                    CallMatchResult $this$isMatching$iv = this.callMatcher.match(it, (CallTemplate)template);
                    boolean $i$f$isMatching = false;
                    boolean bl3 = $this$isMatching$iv == CallMatchResult.Matching;
                    if (bl3) {
                        n = index$iv2;
                        break block5;
                    }
                    ++index$iv2;
                }
                n = matchingTraceIndex = -1;
            }
            if (matchingTraceIndex == -1) {
                AssertionKt.failAssertion((Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> OrderVerifier.verify$lambda$2$lambda$1(this, (CallTemplate)template, templateIndex, callTraces, callTemplates, arg_0)));
                throw new KotlinNothingValueException();
            }
            verifiedTraces.add(currentTraces.get(matchingTraceIndex));
            currentTraces = currentTraces.subList(matchingTraceIndex + 1, currentTraces.size());
        }
        return verifiedTraces;
    }

    private final void appendMainError(StringBuilder $this$appendMainError, CallTemplate template, int templateIndex) {
        $this$appendMainError.append("Expected calls in specified order but not satisfied! ");
        StringBuilder stringBuilder = $this$appendMainError.append("Failed at " + (templateIndex + 1) + ". " + template + '!');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
    }

    private final void appendRenderedResults(StringBuilder $this$appendRenderedResults, List<CallTrace> callTraces, List<CallTemplate> callTemplates) {
        List<TemplateMatchingResult> results = this.resultsComposer.compose(callTraces, callTemplates);
        $this$appendRenderedResults.append(this.renderer.render(results));
    }

    private static final Unit verify$lambda$2$lambda$1(OrderVerifier this$0, CallTemplate $template, int $templateIndex, List $callTraces, List $callTemplates, StringBuilder $this$failAssertion) {
        Intrinsics.checkNotNullParameter((Object)$this$failAssertion, (String)"$this$failAssertion");
        this$0.appendMainError($this$failAssertion, $template, $templateIndex);
        this$0.appendRenderedResults($this$failAssertion, $callTraces, $callTemplates);
        return Unit.INSTANCE;
    }

    public OrderVerifier() {
        this(null, null, null, 7, null);
    }
}

