/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.verify;

import dev.mokkery.internal.calls.CallMatchResult;
import dev.mokkery.internal.calls.CallMatcher;
import dev.mokkery.internal.calls.CallTemplate;
import dev.mokkery.internal.calls.CallTrace;
import dev.mokkery.internal.context.GlobalMokkeryContextKt;
import dev.mokkery.internal.context.MokkeryToolsKt;
import dev.mokkery.internal.render.Renderer;
import dev.mokkery.internal.utils.AssertionKt;
import dev.mokkery.internal.verify.Verifier;
import dev.mokkery.internal.verify.render.TemplateGroupedMatchingResultsRenderer;
import dev.mokkery.internal.verify.results.TemplateGroupedMatchingResults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ1\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0018\u001a\u00020\u0017*\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001c\u00a8\u0006\u001d"}, d2={"Ldev/mokkery/internal/verify/SoftVerifier;", "Ldev/mokkery/internal/verify/Verifier;", "", "atLeast", "atMost", "Ldev/mokkery/internal/calls/CallMatcher;", "callMatcher", "Ldev/mokkery/internal/render/Renderer;", "Ldev/mokkery/internal/verify/results/TemplateGroupedMatchingResults;", "matchingResultsRenderer", "<init>", "(IILdev/mokkery/internal/calls/CallMatcher;Ldev/mokkery/internal/render/Renderer;)V", "", "Ldev/mokkery/internal/calls/CallTrace;", "callTraces", "Ldev/mokkery/internal/calls/CallTemplate;", "callTemplates", "verify", "(Ljava/util/List;Ljava/util/List;)Ljava/util/List;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "template", "callsCount", "", "appendMainError", "(Ljava/lang/StringBuilder;Ldev/mokkery/internal/calls/CallTemplate;I)V", "I", "Ldev/mokkery/internal/calls/CallMatcher;", "Ldev/mokkery/internal/render/Renderer;", "mokkery-runtime"})
@SourceDebugExtension(value={"SMAP\nSoftVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoftVerifier.kt\ndev/mokkery/internal/verify/SoftVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CallMatcher.kt\ndev/mokkery/internal/calls/CallMatcherKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,58:1\n1368#2:59\n1454#2,2:60\n774#2:62\n865#2:63\n866#2:65\n1456#2,3:66\n1485#2:69\n1510#2,3:70\n1513#2,3:80\n15#3:64\n381#4,7:73\n*S KotlinDebug\n*F\n+ 1 SoftVerifier.kt\ndev/mokkery/internal/verify/SoftVerifier\n*L\n22#1:59\n22#1:60,2\n23#1:62\n23#1:63\n23#1:65\n22#1:66,3\n29#1:69\n29#1:70,3\n29#1:80,3\n23#1:64\n29#1:73,7\n*E\n"})
public final class SoftVerifier
implements Verifier {
    private final int atLeast;
    private final int atMost;
    @NotNull
    private final CallMatcher callMatcher;
    @NotNull
    private final Renderer<TemplateGroupedMatchingResults> matchingResultsRenderer;

    public SoftVerifier(int atLeast, int atMost, @NotNull CallMatcher callMatcher, @NotNull Renderer<? super TemplateGroupedMatchingResults> matchingResultsRenderer) {
        Intrinsics.checkNotNullParameter((Object)callMatcher, (String)"callMatcher");
        Intrinsics.checkNotNullParameter(matchingResultsRenderer, (String)"matchingResultsRenderer");
        this.atLeast = atLeast;
        this.atMost = atMost;
        this.callMatcher = callMatcher;
        this.matchingResultsRenderer = matchingResultsRenderer;
    }

    public /* synthetic */ SoftVerifier(int n, int n2, CallMatcher callMatcher, Renderer renderer, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            callMatcher = MokkeryToolsKt.getTools(GlobalMokkeryContextKt.getGlobalMokkeryContext()).getCallMatcher();
        }
        if ((n3 & 8) != 0) {
            renderer = new TemplateGroupedMatchingResultsRenderer(0, null, null, 7, null);
        }
        this(n, n2, callMatcher, renderer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CallTrace> verify(@NotNull List<CallTrace> callTraces, @NotNull List<CallTemplate> callTemplates) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(callTraces, (String)"callTraces");
        Intrinsics.checkNotNullParameter(callTemplates, (String)"callTemplates");
        Iterable $this$flatMap$iv = callTemplates;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            CallTemplate template = (CallTemplate)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = callTraces;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                CallTrace it = (CallTrace)element$iv$iv2;
                boolean bl2 = false;
                CallMatchResult $this$isMatching$iv = this.callMatcher.match(it, template);
                boolean $i$f$isMatching = false;
                boolean bl3 = $this$isMatching$iv == CallMatchResult.Matching;
                if (!bl3) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List matching2 = (List)destination$iv$iv2;
            if (matching2.size() < this.atLeast || matching2.size() > this.atMost) {
                AssertionKt.failAssertion((Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> SoftVerifier.verify$lambda$3$lambda$2(this, template, matching2, callTraces, arg_0)));
                throw new KotlinNothingValueException();
            }
            Iterable list$iv$iv = matching2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List verified = (List)destination$iv$iv;
        return verified;
    }

    private final void appendMainError(StringBuilder $this$appendMainError, CallTemplate template, int callsCount) {
        $this$appendMainError.append("Expected ");
        String callsExpectations = this.atLeast == this.atMost ? "exactly " + this.atLeast + " calls" : (this.atLeast != 1 && this.atMost != Integer.MAX_VALUE ? "calls count to be in range " + this.atLeast + ".." + this.atMost : (this.atLeast != 1 ? "at least " + this.atLeast + " calls" : (this.atMost != Integer.MAX_VALUE ? "at most " + this.atMost + " calls" : "any call")));
        $this$appendMainError.append(callsExpectations);
        StringBuilder stringBuilder = callsCount == 0 ? $this$appendMainError.append(", but no matching calls") : $this$appendMainError.append(", but " + callsCount + " occurred");
        StringBuilder stringBuilder2 = $this$appendMainError.append(" for " + template + '!');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit verify$lambda$3$lambda$2(SoftVerifier this$0, CallTemplate $template, List $matching, List $callTraces, StringBuilder $this$failAssertion) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)$this$failAssertion, (String)"$this$failAssertion");
        this$0.appendMainError($this$failAssertion, $template, $matching.size());
        Iterable iterable = $callTraces;
        CallTemplate callTemplate = $template;
        boolean $i$f$groupBy = false;
        void var8_8 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            CallTrace it = (CallTrace)element$iv$iv;
            boolean bl = false;
            CallMatchResult key$iv$iv = this$0.callMatcher.match(it, $template);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map map = destination$iv$iv;
        CallTemplate callTemplate2 = callTemplate;
        TemplateGroupedMatchingResults results = new TemplateGroupedMatchingResults(callTemplate2, map);
        $this$failAssertion.append(this$0.matchingResultsRenderer.render(results));
        return Unit.INSTANCE;
    }
}

