/*
 * Decompiled with CFR 0.152.
 */
package dev.mokkery.internal.verify.render;

import dev.mokkery.internal.calls.CallTemplate;
import dev.mokkery.internal.calls.CallTrace;
import dev.mokkery.internal.render.Renderer;
import dev.mokkery.internal.render.ToStringRenderer;
import dev.mokkery.internal.verify.results.TemplateMatchingResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B'\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\f\u001a\u00020\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0015\u001a\u00020\u0014*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J9\u0010\u001a\u001a\u00020\u0014*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001cR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001c\u00a8\u0006\u001d"}, d2={"Ldev/mokkery/internal/verify/render/TemplateMatchingResultsRenderer;", "Ldev/mokkery/internal/render/Renderer;", "", "Ldev/mokkery/internal/verify/results/TemplateMatchingResult;", "Ldev/mokkery/internal/calls/CallTrace;", "traceRenderer", "Ldev/mokkery/internal/calls/CallTemplate;", "templateRenderer", "<init>", "(Ldev/mokkery/internal/render/Renderer;Ldev/mokkery/internal/render/Renderer;)V", "value", "", "render", "(Ljava/util/List;)Ljava/lang/String;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Ldev/mokkery/internal/verify/results/TemplateMatchingResult$UnverifiedCall;", "call", "", "columnSize", "", "appendUnverifiedCallLine", "(Ljava/lang/StringBuilder;Ldev/mokkery/internal/verify/results/TemplateMatchingResult$UnverifiedCall;I)V", "template", "trace", "index", "appendTemplateLines", "(Ljava/lang/StringBuilder;Ldev/mokkery/internal/calls/CallTemplate;Ldev/mokkery/internal/calls/CallTrace;II)V", "Ldev/mokkery/internal/render/Renderer;", "mokkery-runtime"})
@SourceDebugExtension(value={"SMAP\nTemplateMatchingResultsRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemplateMatchingResultsRenderer.kt\ndev/mokkery/internal/verify/render/TemplateMatchingResultsRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1863#2,2:55\n*S KotlinDebug\n*F\n+ 1 TemplateMatchingResultsRenderer.kt\ndev/mokkery/internal/verify/render/TemplateMatchingResultsRenderer\n*L\n17#1:55,2\n*E\n"})
public final class TemplateMatchingResultsRenderer
implements Renderer<List<? extends TemplateMatchingResult>> {
    @NotNull
    private final Renderer<CallTrace> traceRenderer;
    @NotNull
    private final Renderer<CallTemplate> templateRenderer;

    public TemplateMatchingResultsRenderer(@NotNull Renderer<? super CallTrace> traceRenderer, @NotNull Renderer<? super CallTemplate> templateRenderer) {
        Intrinsics.checkNotNullParameter(traceRenderer, (String)"traceRenderer");
        Intrinsics.checkNotNullParameter(templateRenderer, (String)"templateRenderer");
        this.traceRenderer = traceRenderer;
        this.templateRenderer = templateRenderer;
    }

    public /* synthetic */ TemplateMatchingResultsRenderer(Renderer renderer, Renderer renderer2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            renderer = ToStringRenderer.INSTANCE;
        }
        if ((n & 2) != 0) {
            renderer2 = ToStringRenderer.INSTANCE;
        }
        this(renderer, renderer2);
    }

    @Override
    @NotNull
    public String render(@NotNull List<? extends TemplateMatchingResult> value) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        StringBuilder $this$render_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int templateCounter = 0;
        templateCounter = 1;
        int indexingColumnSize = String.valueOf(value.size()).length() + 2;
        StringBuilder stringBuilder2 = $this$render_u24lambda_u241.append("Expected calls with matches (x.) and unverified calls (*) in order:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        Iterable $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            TemplateMatchingResult it = (TemplateMatchingResult)element$iv;
            boolean bl2 = false;
            TemplateMatchingResult templateMatchingResult = it;
            if (templateMatchingResult instanceof TemplateMatchingResult.Matching) {
                n = templateCounter;
                templateCounter = n + 1;
                this.appendTemplateLines($this$render_u24lambda_u241, ((TemplateMatchingResult.Matching)it).getTemplate(), ((TemplateMatchingResult.Matching)it).getTrace(), n, indexingColumnSize);
                continue;
            }
            if (templateMatchingResult instanceof TemplateMatchingResult.NoMatch) {
                n = templateCounter;
                templateCounter = n + 1;
                this.appendTemplateLines($this$render_u24lambda_u241, ((TemplateMatchingResult.NoMatch)it).getTemplate(), null, n, indexingColumnSize);
                continue;
            }
            if (templateMatchingResult instanceof TemplateMatchingResult.UnverifiedCall) {
                this.appendUnverifiedCallLine($this$render_u24lambda_u241, (TemplateMatchingResult.UnverifiedCall)it, indexingColumnSize);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void appendUnverifiedCallLine(StringBuilder $this$appendUnverifiedCallLine, TemplateMatchingResult.UnverifiedCall call, int columnSize) {
        $this$appendUnverifiedCallLine.append(StringsKt.padEnd((String)"*", (int)columnSize, (char)' '));
        $this$appendUnverifiedCallLine.append("  ");
        StringBuilder stringBuilder = $this$appendUnverifiedCallLine.append(this.traceRenderer.render(call.getTrace()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
    }

    private final void appendTemplateLines(StringBuilder $this$appendTemplateLines, CallTemplate template, CallTrace trace, int index, int columnSize) {
        StringBuilder stringBuilder;
        $this$appendTemplateLines.append(StringsKt.padEnd$default((String)(index + ". "), (int)columnSize, (char)'\u0000', (int)2, null));
        $this$appendTemplateLines.append("\u250c ");
        StringBuilder stringBuilder2 = $this$appendTemplateLines.append(this.templateRenderer.render(template));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        $this$appendTemplateLines.append(StringsKt.padEnd$default((String)" ", (int)columnSize, (char)'\u0000', (int)2, null));
        $this$appendTemplateLines.append("\u2514 ");
        if (trace != null) {
            StringBuilder stringBuilder3 = $this$appendTemplateLines.append(this.traceRenderer.render(trace));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            StringBuilder stringBuilder4 = stringBuilder3.append('\n');
            stringBuilder = stringBuilder4;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        } else {
            StringBuilder stringBuilder5 = $this$appendTemplateLines.append("No matching call!");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            StringBuilder stringBuilder6 = stringBuilder5.append('\n');
            stringBuilder = stringBuilder6;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        }
    }

    public TemplateMatchingResultsRenderer() {
        this(null, null, 3, null);
    }
}

