/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dev.nokee.core.exec.CommandLineTool;
import dev.nokee.core.exec.CommandLineToolArguments;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.CommandLineToolExecutionHandle;
import dev.nokee.core.exec.CommandLineToolInvocationBuilder;
import dev.nokee.core.exec.internal.DefaultCommandLine;
import dev.nokee.core.exec.internal.DefaultCommandLineToolArguments;
import dev.nokee.core.exec.internal.SystemCommandLineTool;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import lombok.NonNull;

public interface CommandLine {
    public CommandLineTool getTool();

    public CommandLineToolArguments getArguments();

    public CommandLineToolInvocationBuilder newInvocation();

    public <T extends CommandLineToolExecutionHandle> T execute(CommandLineToolExecutionEngine<T> var1);

    public static CommandLine of(Object ... commandLine) {
        return CommandLine.of(Arrays.asList(commandLine));
    }

    public static CommandLine of(@NonNull List<Object> commandLine) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine is marked non-null but is null");
        }
        Iterator<Object> it = commandLine.iterator();
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"The command line must contain at least one element for the executable");
        Object executable = it.next();
        Preconditions.checkNotNull((Object)executable, (Object)"The command line cannot contain null elements");
        ImmutableList.Builder arguments = ImmutableList.builder();
        it.forEachRemaining(element -> {
            Preconditions.checkNotNull((Object)element, (Object)"The command line cannot contain null elements");
            arguments.add(element);
        });
        return new DefaultCommandLine(new SystemCommandLineTool(executable), new DefaultCommandLineToolArguments((List<Object>)arguments.build()));
    }
}

