/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec;

import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.CommandLineToolExecutionHandle;
import dev.nokee.core.exec.CommandLineToolExecutionResult;
import dev.nokee.core.exec.CommandLineToolInvocation;
import dev.nokee.core.exec.internal.DefaultCommandLineToolExecutionResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import org.apache.commons.exec.PumpStreamHandler;

public class ProcessBuilderEngine
implements CommandLineToolExecutionEngine<Handle> {
    @Override
    public Handle submit(CommandLineToolInvocation invocation) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command().add(invocation.getTool().getExecutable());
        processBuilder.command().addAll(invocation.getArguments().get());
        try {
            Process process = processBuilder.start();
            if (invocation.isCapturingStandardOutput()) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outStream);
                streamHandler.setProcessOutputStream(process.getInputStream());
                streamHandler.start();
                return new Handle(process, streamHandler, outStream::toString, () -> String.join((CharSequence)" ", processBuilder.command()));
            }
            throw new RuntimeException("Nop");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Handle
    implements CommandLineToolExecutionHandle {
        private final Process process;
        private final PumpStreamHandler streamHandler;
        private final Supplier<String> standardOutput;
        private final Supplier<String> displayName;

        public CommandLineToolExecutionResult waitFor() {
            try {
                this.process.waitFor();
                this.streamHandler.stop();
                return new DefaultCommandLineToolExecutionResult(this.process.exitValue(), this.standardOutput.get(), this.displayName);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public Handle(Process process, PumpStreamHandler streamHandler, Supplier<String> standardOutput, Supplier<String> displayName) {
            this.process = process;
            this.streamHandler = streamHandler;
            this.standardOutput = standardOutput;
            this.displayName = displayName;
        }
    }
}

