/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec.internal;

import dev.nokee.core.exec.CommandLineToolExecutionResult;
import dev.nokee.core.exec.CommandLineToolLogContent;
import dev.nokee.core.exec.ExecException;
import dev.nokee.core.exec.internal.DefaultCommandLineToolLogContent;
import java.util.function.Supplier;

public class DefaultCommandLineToolExecutionResult
implements CommandLineToolExecutionResult {
    private final int exitValue;
    private final String output;
    private final Supplier<String> displayName;

    @Override
    public CommandLineToolLogContent getStandardOutput() {
        return new DefaultCommandLineToolLogContent(this.output);
    }

    @Override
    public CommandLineToolExecutionResult assertExitValueEquals(int expectedExitValue) throws ExecException {
        if (this.exitValue != expectedExitValue) {
            throw new ExecException(String.format("Process '%s' finished with unexpected exit value %d, was expecting %d", this.displayName.get(), this.exitValue, expectedExitValue));
        }
        return this;
    }

    @Override
    public CommandLineToolExecutionResult assertNormalExitValue() throws ExecException {
        if (this.exitValue != 0) {
            throw new ExecException(String.format("Process '%s' finished with non-zero exit value %d", this.displayName.get(), this.exitValue));
        }
        return this;
    }

    public DefaultCommandLineToolExecutionResult(int exitValue, String output, Supplier<String> displayName) {
        this.exitValue = exitValue;
        this.output = output;
        this.displayName = displayName;
    }

    @Override
    public int getExitValue() {
        return this.exitValue;
    }
}

