/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.language.base.internal;

import dev.nokee.language.base.internal.ConfigurableSourceSet;
import dev.nokee.language.base.internal.UTType;
import dev.nokee.language.base.internal.UTTypeUtils;
import javax.inject.Inject;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.model.ObjectFactory;

public abstract class BaseSourceSet
implements ConfigurableSourceSet {
    private final UTType type;
    private final SourceDirectorySet sourceDirectorySet = this.getObjects().sourceDirectorySet("foo", "bar");

    @Inject
    protected abstract ObjectFactory getObjects();

    protected BaseSourceSet(UTType type) {
        this.type = type;
        this.sourceDirectorySet.getFilter().include(UTTypeUtils.onlyIf(type));
    }

    @Override
    public BaseSourceSet srcDir(Object srcPath) {
        this.sourceDirectorySet.srcDir(srcPath);
        return this;
    }

    @Override
    public UTType getType() {
        return this.type;
    }

    @Override
    public FileTree getAsFileTree() {
        return this.sourceDirectorySet.getAsFileTree().matching(it -> it.include(UTTypeUtils.onlyIf(this.type)));
    }
}

