/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.language.base.internal;

import dev.nokee.language.base.internal.SourceSet;
import dev.nokee.language.base.internal.UTType;
import dev.nokee.language.base.internal.UTTypeUtils;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public abstract class GeneratedSourceSet
implements SourceSet {
    private final UTType type;
    private final Provider<Directory> sourceDirectory;
    private final TaskProvider<? extends Task> generatedByTask;
    private final ConfigurableFileTree fileTree = this.getObjects().fileTree();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    public GeneratedSourceSet(UTType type, Provider<Directory> sourceDirectory, TaskProvider<? extends Task> generatedByTask) {
        this.type = type;
        this.sourceDirectory = sourceDirectory;
        this.generatedByTask = generatedByTask;
        this.fileTree.setDir(sourceDirectory).builtBy(new Object[]{generatedByTask}).include(UTTypeUtils.onlyIf(type));
    }

    public TaskProvider<? extends Task> getGeneratedByTask() {
        return this.generatedByTask;
    }

    @Override
    public UTType getType() {
        return this.type;
    }

    @Override
    public FileTree getAsFileTree() {
        return this.fileTree;
    }
}

