/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.language.base.internal;

import dev.nokee.language.base.internal.UTType;
import java.util.Arrays;
import lombok.NonNull;

public final class UTTypes {
    public static UTType of(String identifier, String[] filenameExtensions) {
        return new DefaultUTType(identifier, filenameExtensions);
    }

    private static final class DefaultUTType
    implements UTType {
        @NonNull
        private final String identifier;
        @NonNull
        private final String[] filenameExtensions;

        @Override
        public String getDisplayName() {
            return String.format("Uniform type '%s'", this.identifier);
        }

        public DefaultUTType(@NonNull String identifier, @NonNull String[] filenameExtensions) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            if (filenameExtensions == null) {
                throw new NullPointerException("filenameExtensions is marked non-null but is null");
            }
            this.identifier = identifier;
            this.filenameExtensions = filenameExtensions;
        }

        @Override
        @NonNull
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        @NonNull
        public String[] getFilenameExtensions() {
            return this.filenameExtensions;
        }

        public String toString() {
            return "UTTypes.DefaultUTType(identifier=" + this.getIdentifier() + ", filenameExtensions=" + Arrays.deepToString(this.getFilenameExtensions()) + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultUTType)) {
                return false;
            }
            DefaultUTType other = (DefaultUTType)o;
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }
    }
}

