/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.base.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;

public abstract class AbstractView<T> {
    @Inject
    protected abstract ProviderFactory getProviders();

    protected abstract Set<? extends T> get();

    public Provider<Set<? extends T>> getElements() {
        return this.getProviders().provider(this::get);
    }

    public <S> Provider<List<? extends S>> map(final Transformer<? extends S, ? super T> mapper) {
        Preconditions.checkArgument((mapper != null ? 1 : 0) != 0, (String)"map mapper for %s must not be null", (Object)this.getDisplayName());
        return this.getElements().map(new Transformer<List<? extends S>, Set<? extends T>>(){

            public List<? extends S> transform(Set<? extends T> elements) {
                ImmutableList.Builder result = ImmutableList.builder();
                for (Object element : elements) {
                    result.add(mapper.transform(element));
                }
                return result.build();
            }
        });
    }

    public <S> Provider<List<? extends S>> flatMap(final Transformer<Iterable<? extends S>, ? super T> mapper) {
        Preconditions.checkArgument((mapper != null ? 1 : 0) != 0, (String)"flatMap mapper for %s must not be null", (Object)this.getDisplayName());
        return this.getElements().map(new Transformer<List<? extends S>, Set<? extends T>>(){

            public List<? extends S> transform(Set<? extends T> elements) {
                ImmutableList.Builder result = ImmutableList.builder();
                for (Object element : elements) {
                    result.addAll((Iterable)mapper.transform(element));
                }
                return result.build();
            }
        });
    }

    public Provider<List<? extends T>> filter(final Spec<? super T> spec) {
        Preconditions.checkArgument((spec != null ? 1 : 0) != 0, (String)"filter spec for %s must not be null", (Object)this.getDisplayName());
        return this.flatMap(new Transformer<Iterable<? extends T>, T>(){

            public Iterable<? extends T> transform(T t) {
                if (spec.isSatisfiedBy(t)) {
                    return ImmutableList.of(t);
                }
                return ImmutableList.of();
            }
        });
    }

    protected abstract String getDisplayName();
}

