/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.base.internal;

import dev.nokee.internal.Cast;
import dev.nokee.language.base.internal.SourceSet;
import dev.nokee.platform.base.Binary;
import dev.nokee.platform.base.BinaryView;
import dev.nokee.platform.base.Variant;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.base.internal.VariantAwareBinaryView;
import dev.nokee.platform.base.internal.VariantCollection;
import dev.nokee.runtime.base.internal.DimensionType;
import javax.inject.Inject;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;

public abstract class BaseComponent<T extends Variant> {
    private final NamingScheme names;
    private final VariantCollection<T> variantCollection;
    private final DomainObjectSet<Binary> binaryCollection;
    private final DomainObjectSet<SourceSet> sourceCollection;
    private final BinaryView<Binary> binaries;

    protected BaseComponent(NamingScheme names, Class<T> variantType) {
        this.names = names;
        this.variantCollection = (VariantCollection)Cast.uncheckedCast("of type erasure", this.getObjects().newInstance(VariantCollection.class, new Object[]{variantType}));
        this.binaries = (BinaryView)Cast.uncheckedCast("of type erasure", this.getObjects().newInstance(VariantAwareBinaryView.class, new Object[]{Binary.class, this.variantCollection.getAsView(variantType)}));
        this.binaryCollection = this.getObjects().domainObjectSet(Binary.class);
        this.sourceCollection = this.getObjects().domainObjectSet(SourceSet.class);
        this.getDimensions().finalizeValueOnRead();
    }

    public String getName() {
        return "main";
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    public abstract SetProperty<DimensionType> getDimensions();

    public abstract SetProperty<BuildVariant> getBuildVariants();

    public abstract Property<T> getDevelopmentVariant();

    public NamingScheme getNames() {
        return this.names;
    }

    public VariantCollection<T> getVariantCollection() {
        return this.variantCollection;
    }

    public DomainObjectSet<Binary> getBinaryCollection() {
        return this.binaryCollection;
    }

    public DomainObjectSet<SourceSet> getSourceCollection() {
        return this.sourceCollection;
    }

    public BinaryView<Binary> getBinaries() {
        return this.binaries;
    }
}

