/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.base.internal;

import dev.nokee.internal.Cast;
import dev.nokee.platform.base.internal.Component;
import dev.nokee.platform.base.internal.ComponentProvider;
import dev.nokee.platform.base.internal.NamingScheme;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.model.ObjectFactory;

public abstract class ComponentCollection<T extends Component> {
    private final Map<String, ComponentCreationArguments> componentCreationArguments = new HashMap<String, ComponentCreationArguments>();
    private final NamedDomainObjectContainer<Component> collection = this.getObjects().domainObjectContainer(Component.class, this::create);

    @Inject
    protected abstract ObjectFactory getObjects();

    private Component create(String name) {
        ComponentCreationArguments args = this.componentCreationArguments.remove(name);
        Component result = (Component)this.getObjects().newInstance(args.type, new Object[]{args.names});
        return result;
    }

    public <S extends T> ComponentProvider<S> register(Class<S> type, NamingScheme names) {
        this.componentCreationArguments.put(names.getComponentName(), new ComponentCreationArguments<S>(type, names));
        return (ComponentProvider)Cast.uncheckedCast("of type erasure", this.getObjects().newInstance(ComponentProvider.class, new Object[]{this.collection.register(names.getComponentName())}));
    }

    public <S extends T> void configureEach(Class<S> type, Action<? super S> action) {
        this.collection.withType(type).configureEach(action);
    }

    private static final class ComponentCreationArguments<T extends Component> {
        private final Class<T> type;
        private final NamingScheme names;

        public ComponentCreationArguments(Class<T> type, NamingScheme names) {
            this.type = type;
            this.names = names;
        }

        public Class<T> getType() {
            return this.type;
        }

        public NamingScheme getNames() {
            return this.names;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComponentCreationArguments)) {
                return false;
            }
            ComponentCreationArguments other = (ComponentCreationArguments)o;
            Class<T> this$type = this.getType();
            Class<T> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            NamingScheme this$names = this.getNames();
            NamingScheme other$names = other.getNames();
            return !(this$names == null ? other$names != null : !this$names.equals(other$names));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            NamingScheme $names = this.getNames();
            result = result * 59 + ($names == null ? 43 : $names.hashCode());
            return result;
        }

        public String toString() {
            return "ComponentCollection.ComponentCreationArguments(type=" + this.getType() + ", names=" + this.getNames() + ")";
        }
    }
}

