/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.base.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dev.nokee.internal.Cast;
import dev.nokee.platform.base.Binary;
import dev.nokee.platform.base.BinaryView;
import dev.nokee.platform.base.internal.AbstractView;
import dev.nokee.platform.base.internal.Realizable;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.specs.Spec;

public abstract class DefaultBinaryView<T extends Binary>
extends AbstractView<T>
implements BinaryView<T> {
    private final Class<T> elementType;
    private final DomainObjectSet<T> delegate;
    private final Realizable variants;

    @Inject
    public DefaultBinaryView(Class<T> elementType, DomainObjectSet<T> delegate, Realizable variants) {
        this.elementType = elementType;
        this.delegate = delegate;
        this.variants = variants;
    }

    @Override
    public void configureEach(Action<? super T> action) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"configure each action for binary view must not be null");
        this.delegate.configureEach(action);
    }

    @Override
    public <S extends T> void configureEach(Class<S> type, Action<? super S> action) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"configure each type for binary view must not be null");
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"configure each action for binary view must not be null");
        this.delegate.withType(type).configureEach(action);
    }

    @Override
    public void configureEach(Spec<? super T> spec, Action<? super T> action) {
        Preconditions.checkArgument((spec != null ? 1 : 0) != 0, (Object)"configure each spec for binary view must not be null");
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"configure each action for binary view must not be null");
        this.delegate.configureEach(element -> {
            if (spec.isSatisfiedBy(element)) {
                action.execute(element);
            }
        });
    }

    @Override
    public <S extends T> BinaryView<S> withType(Class<S> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"binary view subview type must not be null");
        if (this.elementType.equals(type)) {
            return (BinaryView)Cast.uncheckedCast("view types are the same", this);
        }
        return (BinaryView)Cast.uncheckedCast("of type erasure", this.getObjects().newInstance(DefaultBinaryView.class, new Object[]{type, this.delegate.withType(type), this.variants}));
    }

    @Override
    public Set<? extends T> get() {
        this.variants.realize();
        return ImmutableSet.copyOf(this.delegate);
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Override
    protected String getDisplayName() {
        return "binary view";
    }
}

