/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.base.internal;

import com.google.common.collect.ImmutableList;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.runtime.base.internal.Dimension;
import dev.nokee.runtime.base.internal.DimensionType;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.internal.Cast;

public final class DefaultBuildVariant
implements BuildVariant {
    private final List<Dimension> dimensions;

    public static DefaultBuildVariant of(Dimension ... dimensions) {
        return new DefaultBuildVariant((List<Dimension>)ImmutableList.copyOf((Object[])dimensions));
    }

    public static DefaultBuildVariant of(Iterable<Dimension> dimensions) {
        return new DefaultBuildVariant((List<Dimension>)ImmutableList.copyOf(dimensions));
    }

    @Override
    public <T extends Dimension> T getAxisValue(DimensionType<T> type) {
        return (T)((Dimension)Cast.uncheckedCast((Object)this.dimensions.stream().filter(it -> it.getType().equals(type)).findAny().orElseThrow(() -> new GradleException(String.format("Dimension '%s' is not part of this build variant.", type.toString())))));
    }

    @Override
    public boolean hasAxisValue(DimensionType<? extends Dimension> type) {
        return this.dimensions.stream().anyMatch(it -> it.getType().equals(type));
    }

    public DefaultBuildVariant(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    @Override
    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultBuildVariant)) {
            return false;
        }
        DefaultBuildVariant other = (DefaultBuildVariant)o;
        List<Dimension> this$dimensions = this.getDimensions();
        List<Dimension> other$dimensions = other.getDimensions();
        return !(this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Dimension> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        return result;
    }

    public String toString() {
        return "DefaultBuildVariant(dimensions=" + this.getDimensions() + ")";
    }
}

