/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.base.internal;

import com.google.common.base.Preconditions;
import dev.nokee.internal.Cast;
import dev.nokee.platform.base.TaskView;
import dev.nokee.platform.base.internal.AbstractView;
import dev.nokee.platform.base.internal.Realizable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;

public abstract class DefaultTaskView<T extends Task>
extends AbstractView<T>
implements TaskView<T>,
TaskDependency {
    private final Class<T> elementType;
    private final List<TaskProvider<? extends T>> delegate;
    private final Realizable realizeTrigger;

    @Inject
    public DefaultTaskView(Class<T> elementType, List<TaskProvider<? extends T>> delegate, Realizable realizeTrigger) {
        this.elementType = elementType;
        this.delegate = delegate;
        this.realizeTrigger = realizeTrigger;
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Override
    public void configureEach(Action<? super T> action) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"configure each action for task view must not be null");
        for (TaskProvider<? extends T> taskProvider : this.delegate) {
            taskProvider.configure(action);
        }
    }

    @Override
    public <S extends T> void configureEach(Class<S> type, Action<? super S> action) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"configure each action for task view must not be null");
        for (TaskProvider<? extends T> taskProvider : this.delegate) {
            taskProvider.configure(element -> {
                if (type.isAssignableFrom(element.getClass())) {
                    action.execute(type.cast(element));
                }
            });
        }
    }

    @Override
    public void configureEach(Spec<? super T> spec, Action<? super T> action) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"configure each action for task view must not be null");
        for (TaskProvider<? extends T> taskProvider : this.delegate) {
            taskProvider.configure(element -> {
                if (spec.isSatisfiedBy(element)) {
                    action.execute(element);
                }
            });
        }
    }

    @Override
    public <S extends T> TaskView<S> withType(Class<S> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"task view subview type must not be null");
        if (this.elementType.equals(type)) {
            return (TaskView)Cast.uncheckedCast("view types are the same", this);
        }
        return (TaskView)Cast.uncheckedCast("of type erasure", this.getObjects().newInstance(DefaultTaskView.class, new Object[]{type, this.delegate.stream().filter((? super T it) -> type.isAssignableFrom(DefaultTaskView.typeOf(it))).collect(Collectors.toList()), this.realizeTrigger}));
    }

    private static Class<?> typeOf(Provider<?> provider) {
        return ((ProviderInternal)provider).getType();
    }

    @Override
    public Set<? extends T> get() {
        this.realizeTrigger.realize();
        return this.delegate.stream().map(Provider::get).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<? extends Task> getDependencies(@Nullable Task task) {
        return this.delegate.stream().map(Provider::get).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    protected String getDisplayName() {
        return "task view";
    }
}

