/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.base.internal;

import com.google.common.collect.ImmutableList;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.GroupId;
import dev.nokee.runtime.base.internal.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Named;
import org.gradle.util.GUtil;

public class NamingScheme {
    private final String baseName;
    private final ComponentName componentName;
    private final ComponentDisplayName displayName;
    private final ConfigurationPrefix configurationPrefix;
    private final Dimensions dimensions;

    public static NamingScheme asMainComponent(String baseName) {
        return new NamingScheme(baseName, ComponentName.ofMain(), ComponentDisplayName.missing(), ConfigurationPrefix.none(), Dimensions.empty());
    }

    public static NamingScheme asComponent(String baseName, String name) {
        return new NamingScheme(baseName, ComponentName.of(name), ComponentDisplayName.missing(), ConfigurationPrefix.none(), Dimensions.empty());
    }

    public final String getConfigurationName(String target) {
        return this.componentName.prefix(this.dimensions.prefix(this.configurationPrefix.prefix(target)));
    }

    public final String getConfigurationNameWithoutPrefix(String target) {
        return this.componentName.prefix(this.dimensions.prefix(target));
    }

    public String getComponentName() {
        return this.componentName.get();
    }

    public BaseNameNamingScheme getBaseName() {
        return new BaseNameNamingScheme();
    }

    public String getResourcePath(GroupId groupId) {
        return groupId.get().map(it -> it.replace('.', '/') + '/').orElse("") + this.dimensions.getAsKebab().orElse("");
    }

    public <T extends Named> NamingScheme withVariantDimension(T value, Collection<? extends T> allValuesForAxis) {
        if (allValuesForAxis.size() == 1) {
            return this;
        }
        return new NamingScheme(this.baseName, this.componentName, this.displayName, this.configurationPrefix, this.dimensions.add(value.getName()));
    }

    public NamingScheme forBuildVariant(BuildVariant value, Collection<? extends BuildVariant> allBuildVariants) {
        NamingScheme result = this;
        int index = 0;
        for (Dimension dimension : value.getDimensions()) {
            if (!(dimension instanceof Named)) {
                throw new IllegalArgumentException("The dimension needs to implement Named, it's an implementation detail at this point");
            }
            Set allValuesForAxis = allBuildVariants.stream().map(this.extractDimensionAtIndex(index)).collect(Collectors.toSet());
            result = result.withVariantDimension((Named)dimension, allValuesForAxis);
            ++index;
        }
        return result;
    }

    private Function<BuildVariant, Named> extractDimensionAtIndex(int index) {
        return buildVariant -> (Named)buildVariant.getDimensions().get(index);
    }

    public String getTaskName(String verb) {
        return this.dimensions.suffix(this.componentName.suffix(verb));
    }

    public String getTaskName(String verb, String object) {
        return this.getTaskName(verb) + StringUtils.capitalize((String)object);
    }

    public String getOutputDirectoryBase(String outputType) {
        return outputType + NamingScheme.prefixWithPathSeparator(this.componentName.get()) + this.dimensions.get().map(NamingScheme::prefixWithPathSeparator).orElse("");
    }

    private static String prefixWithPathSeparator(String value) {
        return "/" + value;
    }

    public NamingScheme withConfigurationNamePrefix(String configurationNamePrefix) {
        return new NamingScheme(this.baseName, this.componentName, this.displayName, ConfigurationPrefix.of(configurationNamePrefix), this.dimensions);
    }

    public NamingScheme withComponentDisplayName(String componentDisplayName) {
        return new NamingScheme(this.baseName, this.componentName, ComponentDisplayName.of(componentDisplayName), this.configurationPrefix, this.dimensions);
    }

    public String getConfigurationDescription(String format) {
        return String.format(format, this.displayName.get());
    }

    public NamingScheme(String baseName, ComponentName componentName, ComponentDisplayName displayName, ConfigurationPrefix configurationPrefix, Dimensions dimensions) {
        this.baseName = baseName;
        this.componentName = componentName;
        this.displayName = displayName;
        this.configurationPrefix = configurationPrefix;
        this.dimensions = dimensions;
    }

    private static class DefaultComponentDisplayName
    implements ComponentDisplayName {
        private final String displayName;

        @Override
        public String get() {
            return this.displayName;
        }

        public DefaultComponentDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }

    private static class MissingComponentDisplayName
    implements ComponentDisplayName {
        private static final MissingComponentDisplayName INSTANCE = new MissingComponentDisplayName();

        private MissingComponentDisplayName() {
        }

        @Override
        public String get() {
            throw new IllegalStateException("make sure component display name is set");
        }
    }

    public static interface ComponentDisplayName {
        public String get();

        public static ComponentDisplayName missing() {
            return MissingComponentDisplayName.INSTANCE;
        }

        public static ComponentDisplayName of(String value) {
            return new DefaultComponentDisplayName(value);
        }
    }

    public static class OtherComponentName
    extends BaseValueNamingSegment
    implements ComponentName {
        public OtherComponentName(String value) {
            super(value);
        }

        @Override
        public String get() {
            return this.value;
        }
    }

    public static class MainComponentName
    extends BaseNoopNamingSegment
    implements ComponentName {
        @Override
        public String get() {
            return "main";
        }
    }

    public static interface ComponentName
    extends Prefixer,
    Suffixer {
        public String get();

        public static ComponentName ofMain() {
            return new MainComponentName();
        }

        public static ComponentName of(String name) {
            return new OtherComponentName(name);
        }
    }

    public static class WithDimensions
    extends BaseValueNamingSegment
    implements Dimensions {
        private final List<String> dimensions;

        public WithDimensions(List<String> dimensions) {
            super(WithDimensions.createPrefix(dimensions));
            this.dimensions = dimensions;
        }

        @Override
        public Dimensions add(String dimension) {
            return new WithDimensions((List<String>)ImmutableList.builder().addAll(this.dimensions).add((Object)dimension).build());
        }

        @Override
        public List<String> getDimensions() {
            return this.dimensions;
        }

        private static String createPrefix(List<String> dimensions) {
            return StringUtils.uncapitalize((String)dimensions.stream().map(StringUtils::capitalize).collect(Collectors.joining()));
        }

        @Override
        public Optional<String> get() {
            return Optional.of(this.value);
        }

        @Override
        public Optional<String> getAsKebab() {
            return Optional.of(String.join((CharSequence)"-", this.dimensions));
        }
    }

    public static class NoDimensions
    extends BaseNoopNamingSegment
    implements Dimensions {
        public static final NoDimensions INSTANCE = new NoDimensions();

        @Override
        public Dimensions add(String dimension) {
            return new WithDimensions((List<String>)ImmutableList.of((Object)dimension));
        }

        @Override
        public List<String> getDimensions() {
            return ImmutableList.of();
        }

        @Override
        public Optional<String> get() {
            return Optional.empty();
        }

        @Override
        public Optional<String> getAsKebab() {
            return Optional.empty();
        }
    }

    public static interface Dimensions
    extends Prefixer,
    Suffixer {
        public Dimensions add(String var1);

        public List<String> getDimensions();

        public Optional<String> get();

        public Optional<String> getAsKebab();

        public static Dimensions empty() {
            return NoDimensions.INSTANCE;
        }
    }

    private static class DefaultConfigurationPrefix
    extends BaseValueNamingSegment
    implements ConfigurationPrefix {
        public DefaultConfigurationPrefix(String value) {
            super(value);
        }
    }

    private static class AbsentConfigurationPrefix
    extends BaseNoopNamingSegment
    implements ConfigurationPrefix {
        private static final AbsentConfigurationPrefix INSTANCE = new AbsentConfigurationPrefix();

        private AbsentConfigurationPrefix() {
        }
    }

    public static interface ConfigurationPrefix
    extends Prefixer {
        public static ConfigurationPrefix none() {
            return AbsentConfigurationPrefix.INSTANCE;
        }

        public static ConfigurationPrefix of(String value) {
            return new DefaultConfigurationPrefix(value);
        }
    }

    public static abstract class BaseNoopNamingSegment {
        public String prefix(String target) {
            return target;
        }

        public String suffix(String target) {
            return target;
        }
    }

    public static abstract class BaseValueNamingSegment {
        protected final String value;

        public String prefix(String target) {
            return this.value + StringUtils.capitalize((String)target);
        }

        public String suffix(String target) {
            return target + StringUtils.capitalize((String)this.value);
        }

        public BaseValueNamingSegment(String value) {
            this.value = value;
        }
    }

    public static interface Suffixer {
        public String suffix(String var1);
    }

    public static interface Prefixer {
        public String prefix(String var1);
    }

    public class BaseNameNamingScheme {
        private BaseNameNamingScheme() {
        }

        public String getAsString() {
            return NamingScheme.this.baseName;
        }

        public String getAsCamelCase() {
            return GUtil.toCamelCase((CharSequence)NamingScheme.this.baseName);
        }

        public String withKababDimensions() {
            ArrayList<String> values = new ArrayList<String>();
            values.add(NamingScheme.this.baseName);
            NamingScheme.this.dimensions.getAsKebab().ifPresent(values::add);
            return String.join((CharSequence)"-", values);
        }
    }
}

