/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.base.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dev.nokee.internal.Cast;
import dev.nokee.platform.base.Binary;
import dev.nokee.platform.base.BinaryView;
import dev.nokee.platform.base.Variant;
import dev.nokee.platform.base.VariantView;
import dev.nokee.platform.base.internal.AbstractView;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.specs.Spec;

public abstract class VariantAwareBinaryView<T extends Binary>
extends AbstractView<T>
implements BinaryView<T> {
    private final Class<T> binaryType;
    private final VariantView<? extends Variant> variants;

    @Inject
    public VariantAwareBinaryView(Class<T> binaryType, VariantView<? extends Variant> variants) {
        this.binaryType = binaryType;
        this.variants = variants;
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Override
    public <S extends T> void configureEach(Class<S> type, Action<? super S> action) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"configure each action for binary view must not be null");
        this.variants.configureEach((Action<? extends Variant>)((Action)variant -> variant.getBinaries().configureEach(type, action)));
    }

    @Override
    public <S extends T> BinaryView<S> withType(Class<S> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"binary view subview type must not be null");
        if (this.binaryType.equals(type)) {
            return (BinaryView)Cast.uncheckedCast("view types are the same", this);
        }
        return (BinaryView)Cast.uncheckedCast("of type erasure", this.getObjects().newInstance(VariantAwareBinaryView.class, new Object[]{type, this.variants}));
    }

    @Override
    public void configureEach(Action<? super T> action) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"configure each action for binary view must not be null");
        this.variants.configureEach((Action<? extends Variant>)((Action)variant -> variant.getBinaries().configureEach(this.binaryType, action)));
    }

    @Override
    public void configureEach(Spec<? super T> spec, Action<? super T> action) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"configure each action for binary view must not be null");
        this.variants.configureEach((Action<? extends Variant>)((Action)variant -> variant.getBinaries().withType(this.binaryType).configureEach(spec, action)));
    }

    @Override
    public Set<? extends T> get() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.variants.get().forEach(it -> builder.addAll(it.getBinaries().withType(this.binaryType).get()));
        return builder.build();
    }

    @Override
    protected String getDisplayName() {
        return "binary view";
    }
}

