/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.base.internal;

import com.google.common.base.Preconditions;
import dev.nokee.internal.Cast;
import dev.nokee.platform.base.Variant;
import dev.nokee.platform.base.VariantView;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.DefaultVariantView;
import dev.nokee.platform.base.internal.KnownVariant;
import dev.nokee.platform.base.internal.Realizable;
import dev.nokee.platform.base.internal.VariantFactory;
import dev.nokee.platform.base.internal.VariantProvider;
import dev.nokee.runtime.base.internal.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.model.ObjectFactory;

public abstract class VariantCollection<T extends Variant>
implements Realizable {
    private final Map<String, VariantCreationArguments<T>> variantCreationArguments = new HashMap<String, VariantCreationArguments<T>>();
    private final Class<T> elementType;
    private final NamedDomainObjectContainer<T> collection;
    private boolean disallowChanges = false;
    private final DomainObjectSet<KnownVariant<T>> knownVariants = (DomainObjectSet)Cast.uncheckedCast("of type erasure", this.getObjects().domainObjectSet(KnownVariant.class));

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    public VariantCollection(Class<T> elementType) {
        Preconditions.checkArgument((boolean)Named.class.isAssignableFrom(elementType), (Object)"element type of the collection needs to implement Named");
        this.elementType = elementType;
        this.collection = this.getObjects().domainObjectContainer(elementType, this::create);
    }

    private T create(String name) {
        VariantCreationArguments<T> args = this.variantCreationArguments.remove(name);
        Object result = ((VariantCreationArguments)args).factory.create(name, ((VariantCreationArguments)args).buildVariant);
        return result;
    }

    public VariantProvider<T> registerVariant(BuildVariant buildVariant, VariantFactory<T> factory) {
        if (this.disallowChanges) {
            throw new IllegalStateException("The value cannot be changed any further.");
        }
        String variantName = StringUtils.uncapitalize((String)buildVariant.getDimensions().stream().map(this::determineName).map(StringUtils::capitalize).collect(Collectors.joining()));
        this.variantCreationArguments.put(variantName, new VariantCreationArguments<T>(buildVariant, factory));
        return (VariantProvider)Cast.uncheckedCast("of type erasure", this.getObjects().newInstance(VariantProvider.class, new Object[]{buildVariant, this.elementType, this.collection.register(variantName)}));
    }

    private String determineName(Dimension dimension) {
        if (dimension instanceof Named) {
            return ((Named)dimension).getName();
        }
        throw new IllegalArgumentException("Can't determine name");
    }

    public <S extends Variant> VariantView<S> getAsView(Class<S> viewElementType) {
        Preconditions.checkArgument((boolean)viewElementType.isAssignableFrom(this.elementType), (Object)"element type of the view needs to be the same type or a supertype of the element of this collection");
        return (VariantView)Cast.uncheckedCast("of type erasure", this.getObjects().newInstance(DefaultVariantView.class, new Object[]{viewElementType, this.collection, this}));
    }

    @Override
    public void realize() {
        if (!this.disallowChanges) {
            throw new IllegalStateException("Please disallow changes before realizing the variants.");
        }
        this.collection.iterator().next();
    }

    public VariantCollection<T> disallowChanges() {
        this.disallowChanges = true;
        return this;
    }

    public Set<T> get() {
        return this.collection;
    }

    public void whenElementKnown(Action<? super KnownVariant<T>> action) {
        this.knownVariants.all(action);
    }

    private static final class VariantCreationArguments<T extends Variant> {
        private final BuildVariant buildVariant;
        private final VariantFactory<T> factory;

        public VariantCreationArguments(BuildVariant buildVariant, VariantFactory<T> factory) {
            this.buildVariant = buildVariant;
            this.factory = factory;
        }

        public BuildVariant getBuildVariant() {
            return this.buildVariant;
        }

        public VariantFactory<T> getFactory() {
            return this.factory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariantCreationArguments)) {
                return false;
            }
            VariantCreationArguments other = (VariantCreationArguments)o;
            BuildVariant this$buildVariant = this.getBuildVariant();
            BuildVariant other$buildVariant = other.getBuildVariant();
            if (this$buildVariant == null ? other$buildVariant != null : !this$buildVariant.equals(other$buildVariant)) {
                return false;
            }
            VariantFactory<T> this$factory = this.getFactory();
            VariantFactory<T> other$factory = other.getFactory();
            return !(this$factory == null ? other$factory != null : !this$factory.equals(other$factory));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BuildVariant $buildVariant = this.getBuildVariant();
            result = result * 59 + ($buildVariant == null ? 43 : $buildVariant.hashCode());
            VariantFactory<T> $factory = this.getFactory();
            result = result * 59 + ($factory == null ? 43 : $factory.hashCode());
            return result;
        }

        public String toString() {
            return "VariantCollection.VariantCreationArguments(buildVariant=" + this.getBuildVariant() + ", factory=" + this.getFactory() + ")";
        }
    }
}

