/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.jni.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dev.nokee.language.base.internal.LanguageSourceSetInternal;
import dev.nokee.platform.base.BinaryAwareComponent;
import dev.nokee.platform.base.DependencyAwareComponent;
import dev.nokee.platform.base.VariantView;
import dev.nokee.platform.base.internal.BaseComponent;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.DefaultBuildVariant;
import dev.nokee.platform.base.internal.GroupId;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.jni.JniLibrary;
import dev.nokee.platform.jni.JniLibraryDependencies;
import dev.nokee.platform.jni.internal.JniLibraryDependenciesInternal;
import dev.nokee.platform.jni.internal.JniLibraryInternal;
import dev.nokee.platform.jni.internal.JniLibraryNativeDependenciesInternal;
import dev.nokee.platform.nativebase.internal.BaseNativeComponent;
import dev.nokee.platform.nativebase.internal.dependencies.DefaultNativeComponentDependencies;
import dev.nokee.runtime.base.internal.Dimension;
import dev.nokee.runtime.nativebase.MachineArchitecture;
import dev.nokee.runtime.nativebase.OperatingSystemFamily;
import dev.nokee.runtime.nativebase.TargetMachine;
import dev.nokee.runtime.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;

public abstract class JniLibraryComponentInternal
extends BaseComponent<JniLibraryInternal>
implements DependencyAwareComponent<JniLibraryDependencies>,
BinaryAwareComponent {
    private final JniLibraryDependenciesInternal dependencies;
    private final GroupId groupId;
    private final DomainObjectSet<LanguageSourceSetInternal> sources;

    @Inject
    public JniLibraryComponentInternal(NamingScheme names, GroupId groupId) {
        super(names, JniLibraryInternal.class);
        this.dependencies = (JniLibraryDependenciesInternal)this.getObjects().newInstance(JniLibraryDependenciesInternal.class, new Object[]{names, this.getObjects().newInstance(DefaultNativeComponentDependencies.class, new Object[]{names.withConfigurationNamePrefix("native").withComponentDisplayName("JNI shared library")})});
        this.groupId = groupId;
        this.sources = this.getObjects().domainObjectSet(LanguageSourceSetInternal.class);
        this.getDimensions().convention((Iterable)ImmutableSet.of((Object)DefaultOperatingSystemFamily.DIMENSION_TYPE, (Object)DefaultMachineArchitecture.DIMENSION_TYPE));
        this.getDimensions().disallowChanges();
        this.getBuildVariants().convention(this.getProviders().provider(this::createBuildVariants));
        this.getBuildVariants().finalizeValueOnRead();
        this.getBuildVariants().disallowChanges();
        this.getDevelopmentVariant().convention(this.getDefaultVariant());
        this.getDevelopmentVariant().disallowChanges();
    }

    @Inject
    protected abstract ProviderFactory getProviders();

    public JniLibraryDependenciesInternal getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super JniLibraryDependencies> action) {
        action.execute((Object)this.dependencies);
    }

    protected Provider<JniLibraryInternal> getDefaultVariant() {
        return this.getProviders().provider(() -> {
            List variants = this.getVariantCollection().get().stream().filter(it -> {
                DefaultOperatingSystemFamily osFamily = (DefaultOperatingSystemFamily)it.getBuildVariant().getAxisValue(DefaultOperatingSystemFamily.DIMENSION_TYPE);
                DefaultMachineArchitecture architecture = (DefaultMachineArchitecture)it.getBuildVariant().getAxisValue(DefaultMachineArchitecture.DIMENSION_TYPE);
                return DefaultOperatingSystemFamily.HOST.equals((Object)osFamily) && DefaultMachineArchitecture.HOST.equals((Object)architecture);
            }).collect(Collectors.toList());
            if (variants.isEmpty()) {
                return null;
            }
            return (JniLibraryInternal)BaseNativeComponent.one(variants);
        });
    }

    public VariantView<JniLibrary> getVariants() {
        return this.getVariantCollection().getAsView(JniLibrary.class);
    }

    public JniLibraryInternal createVariant(String name, BuildVariant buildVariant, JniLibraryNativeDependenciesInternal variantDependencies) {
        Preconditions.checkArgument((buildVariant.getDimensions().size() == 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(buildVariant.getDimensions().get(0) instanceof OperatingSystemFamily));
        Preconditions.checkArgument((boolean)(buildVariant.getDimensions().get(1) instanceof MachineArchitecture));
        NamingScheme names = this.getNames().forBuildVariant(buildVariant, (Collection)this.getBuildVariants().get());
        JniLibraryInternal result = (JniLibraryInternal)this.getObjects().newInstance(JniLibraryInternal.class, new Object[]{name, names, this.sources, buildVariant, this.groupId, this.getBinaryCollection(), variantDependencies});
        return result;
    }

    private List<BuildVariant> createBuildVariants() {
        Set targetMachines = (Set)this.getTargetMachines().get();
        return targetMachines.stream().map(it -> (DefaultTargetMachine)it).map(it -> DefaultBuildVariant.of((Dimension[])new Dimension[]{it.getOperatingSystemFamily(), it.getArchitecture()})).collect(Collectors.toList());
    }

    public Configuration getJvmImplementationDependencies() {
        return this.dependencies.getJvmImplementationDependencies();
    }

    public DomainObjectSet<LanguageSourceSetInternal> getSources() {
        return this.sources;
    }

    public abstract SetProperty<TargetMachine> getTargetMachines();
}

