/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.jni.internal;

import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.jni.JniLibraryDependencies;
import dev.nokee.platform.nativebase.internal.ConfigurationUtils;
import dev.nokee.platform.nativebase.internal.dependencies.DefaultDependencyBucket;
import dev.nokee.platform.nativebase.internal.dependencies.DefaultNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.DependencyBucket;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.model.ObjectFactory;

public abstract class JniLibraryDependenciesInternal
implements JniLibraryDependencies {
    private final DependencyBucket apiDependencies;
    private final DependencyBucket jvmImplementationDependencies;
    private final DependencyBucket jvmRuntimeOnly;
    private final DefaultNativeComponentDependencies nativeDelegate;

    @Inject
    public JniLibraryDependenciesInternal(NamingScheme names, DefaultNativeComponentDependencies nativeDelegate) {
        this.nativeDelegate = nativeDelegate;
        ConfigurationUtils builder = (ConfigurationUtils)this.getObjects().newInstance(ConfigurationUtils.class, new Object[0]);
        this.apiDependencies = (DependencyBucket)this.getObjects().newInstance(DefaultDependencyBucket.class, new Object[]{Optional.ofNullable((Configuration)this.getConfigurations().findByName(names.getConfigurationName("api"))).orElseGet(() -> (Configuration)this.getConfigurations().create(names.getConfigurationName("api"), (Action)builder.asBucket().withDescription("API dependencies for JNI library.")))});
        this.jvmImplementationDependencies = (DependencyBucket)this.getObjects().newInstance(DefaultDependencyBucket.class, new Object[]{this.getConfigurations().create(names.getConfigurationName("jvmImplementation"), (Action)builder.asBucket(this.apiDependencies.getAsConfiguration()).withDescription("Implementation only dependencies for JNI library."))});
        this.jvmRuntimeOnly = (DependencyBucket)this.getObjects().newInstance(DefaultDependencyBucket.class, new Object[]{this.getConfigurations().create(names.getConfigurationName("jvmRuntimeOnly"), (Action)builder.asBucket().withDescription("Runtime only dependencies for JNI library."))});
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Override
    public void api(Object notation) {
        this.apiDependencies.addDependency(notation);
    }

    @Override
    public void api(Object notation, Action<? super ModuleDependency> action) {
        this.apiDependencies.addDependency(notation, action);
    }

    @Override
    public void jvmImplementation(Object notation) {
        this.jvmImplementationDependencies.addDependency(notation);
    }

    @Override
    public void jvmImplementation(Object notation, Action<? super ModuleDependency> action) {
        this.jvmImplementationDependencies.addDependency(notation, action);
    }

    @Override
    public void jvmRuntimeOnly(Object notation) {
        this.jvmRuntimeOnly.addDependency(notation);
    }

    @Override
    public void jvmRuntimeOnly(Object notation, Action<? super ModuleDependency> action) {
        this.jvmRuntimeOnly.addDependency(notation, action);
    }

    @Override
    public void nativeImplementation(Object notation) {
        this.nativeDelegate.implementation(notation);
    }

    @Override
    public void nativeImplementation(Object notation, Action<? super ModuleDependency> action) {
        this.nativeDelegate.implementation(notation, action);
    }

    @Override
    public void nativeLinkOnly(Object notation) {
        this.nativeDelegate.linkOnly(notation);
    }

    @Override
    public void nativeLinkOnly(Object notation, Action<? super ModuleDependency> action) {
        this.nativeDelegate.linkOnly(notation, action);
    }

    @Override
    public void nativeRuntimeOnly(Object notation) {
        this.nativeDelegate.runtimeOnly(notation);
    }

    @Override
    public void nativeRuntimeOnly(Object notation, Action<? super ModuleDependency> action) {
        this.nativeDelegate.runtimeOnly(notation, action);
    }

    public Configuration getApiDependencies() {
        return this.apiDependencies.getAsConfiguration();
    }

    public Configuration getJvmImplementationDependencies() {
        return this.jvmImplementationDependencies.getAsConfiguration();
    }

    public Configuration getJvmRuntimeOnlyDependencies() {
        return this.jvmRuntimeOnly.getAsConfiguration();
    }

    public Configuration getNativeImplementationDependencies() {
        return this.nativeDelegate.getImplementationDependencies();
    }

    public Configuration getNativeLinkOnlyDependencies() {
        return this.nativeDelegate.getLinkOnlyDependencies();
    }

    public Configuration getNativeRuntimeOnlyDependencies() {
        return this.nativeDelegate.getRuntimeOnlyDependencies();
    }

    public DefaultNativeComponentDependencies getNativeDelegate() {
        return this.nativeDelegate;
    }
}

