/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal;

import com.google.common.collect.ImmutableList;
import dev.nokee.core.exec.CommandLine;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.ProcessBuilderEngine;
import dev.nokee.language.base.internal.GeneratedSourceSet;
import dev.nokee.language.base.tasks.SourceCompile;
import dev.nokee.language.c.internal.tasks.CCompileTask;
import dev.nokee.language.c.tasks.CCompile;
import dev.nokee.language.cpp.internal.tasks.CppCompileTask;
import dev.nokee.language.cpp.tasks.CppCompile;
import dev.nokee.language.objectivec.internal.tasks.ObjectiveCCompileTask;
import dev.nokee.language.objectivec.tasks.ObjectiveCCompile;
import dev.nokee.language.objectivecpp.internal.tasks.ObjectiveCppCompileTask;
import dev.nokee.language.objectivecpp.tasks.ObjectiveCppCompile;
import dev.nokee.language.swift.tasks.internal.SwiftCompileTask;
import dev.nokee.platform.base.Binary;
import dev.nokee.platform.base.TaskView;
import dev.nokee.platform.base.internal.DefaultTaskView;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.nativebase.NativeBinary;
import dev.nokee.platform.nativebase.SharedLibraryBinary;
import dev.nokee.platform.nativebase.StaticLibraryBinary;
import dev.nokee.platform.nativebase.internal.NativePlatformFactory;
import dev.nokee.platform.nativebase.internal.ToolChainSelectorInternal;
import dev.nokee.platform.nativebase.internal.dependencies.NativeIncomingDependencies;
import dev.nokee.runtime.nativebase.TargetMachine;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.language.nativeplatform.tasks.AbstractNativeSourceCompileTask;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.util.GUtil;

public abstract class BaseNativeBinary
implements Binary,
NativeBinary {
    private final ToolChainSelectorInternal toolChainSelector = (ToolChainSelectorInternal)this.getObjects().newInstance(ToolChainSelectorInternal.class, new Object[0]);
    private final NamingScheme names;
    protected final TaskView<Task> compileTasks;
    private final DomainObjectSet<GeneratedSourceSet> objectSourceSets;
    private final DefaultTargetMachine targetMachine;
    private final NativeIncomingDependencies dependencies;

    public BaseNativeBinary(NamingScheme names, DomainObjectSet<GeneratedSourceSet> objectSourceSets, DefaultTargetMachine targetMachine, NativeIncomingDependencies dependencies) {
        this.names = names;
        this.compileTasks = (TaskView)this.getObjects().newInstance(DefaultTaskView.class, new Object[]{Task.class, objectSourceSets.stream().map(GeneratedSourceSet::getGeneratedByTask).collect(Collectors.toList()), () -> {}});
        this.objectSourceSets = objectSourceSets;
        this.targetMachine = targetMachine;
        this.dependencies = dependencies;
        this.compileTasks.configureEach(AbstractNativeCompileTask.class, this::configureNativeSourceCompileTask);
        this.compileTasks.configureEach(AbstractNativeCompileTask.class, task -> {
            task.getIncludes().from(new Object[]{dependencies.getHeaderSearchPaths()});
            task.getCompilerArgs().addAll(this.getProviders().provider(() -> dependencies.getFrameworkSearchPaths().getFiles().stream().flatMap(this::toFrameworkSearchPathFlags).collect(Collectors.toList())));
        });
        this.compileTasks.configureEach(SwiftCompileTask.class, this::configureSwiftCompileTask);
        this.compileTasks.configureEach(SwiftCompileTask.class, task -> {
            task.getModules().from(new Object[]{dependencies.getSwiftModules()});
            task.getCompilerArgs().addAll(this.getProviders().provider(() -> dependencies.getFrameworkSearchPaths().getFiles().stream().flatMap(this::toFrameworkSearchPathFlags).collect(Collectors.toList())));
        });
    }

    public Provider<Set<FileSystemLocation>> getHeaderSearchPaths() {
        return this.getObjects().fileCollection().from(new Object[]{"src/main/headers"}).from(new Object[]{this.compileTasks.withType(AbstractNativeSourceCompileTask.class).map(it -> it.getIncludes())}).from(new Object[]{this.getDependencies().getHeaderSearchPaths()}).from(new Object[]{this.compileTasks.withType(AbstractNativeSourceCompileTask.class).map(it -> it.getSystemIncludes())}).getElements();
    }

    public Provider<Set<FileSystemLocation>> getImportSearchPaths() {
        return this.getObjects().fileCollection().from(new Object[]{this.getCompileTasks().withType(SwiftCompileTask.class).getElements().map(tasks -> tasks.stream().map(task -> task.getModuleFile().map(it -> it.getAsFile().getParentFile())).collect(Collectors.toList()))}).from(new Object[]{this.getDependencies().getSwiftModules().getElements().map(files -> files.stream().map(it -> it.getAsFile().getParentFile()).collect(Collectors.toList()))}).getElements();
    }

    public Provider<Set<FileSystemLocation>> getFrameworkSearchPaths() {
        return this.getObjects().fileCollection().from(new Object[]{this.getDependencies().getFrameworkSearchPaths()}).from(new Object[]{this.getDependencies().getLinkFrameworks().getElements().map(files -> files.stream().map(it -> it.getAsFile().getParentFile()).collect(Collectors.toList()))}).from(new Object[]{this.compileTasks.withType(AbstractNativeSourceCompileTask.class).map(it -> BaseNativeBinary.extractFrameworkSearchPaths((List)it.getCompilerArgs().get()))}).getElements();
    }

    private static List<File> extractFrameworkSearchPaths(List<String> args) {
        ArrayList<File> result = new ArrayList<File>();
        boolean nextArgIsFrameworkSearchPath = false;
        for (String arg : args) {
            if (nextArgIsFrameworkSearchPath) {
                result.add(new File(arg));
                nextArgIsFrameworkSearchPath = false;
                continue;
            }
            if (!arg.equals("-F")) continue;
            nextArgIsFrameworkSearchPath = true;
        }
        return result;
    }

    private void configureNativeSourceCompileTask(AbstractNativeCompileTask task) {
        task.getObjectFileDir().convention(this.languageNameSuffixFor(task).flatMap(languageNameSuffix -> this.getLayout().getBuildDirectory().dir(this.names.getOutputDirectoryBase("objs") + "/main" + languageNameSuffix)));
        task.getTargetPlatform().set(this.getTargetPlatform());
        task.getTargetPlatform().finalizeValueOnRead();
        task.getTargetPlatform().disallowChanges();
        task.setDebuggable(false);
        task.setOptimized(false);
        task.setPositionIndependentCode(true);
        task.getToolChain().set(this.selectNativeToolChain((TargetMachine)this.targetMachine));
        task.getToolChain().finalizeValueOnRead();
        task.getToolChain().disallowChanges();
        task.getIncludes().from(new Object[]{"src/main/headers"});
        task.getSystemIncludes().from(new Object[]{this.getSystemIncludes(task)});
    }

    private Provider<String> languageNameSuffixFor(AbstractNativeCompileTask task) {
        return this.getProviders().provider(() -> {
            if (task instanceof CCompile) {
                return "C";
            }
            if (task instanceof CppCompile) {
                return "Cpp";
            }
            if (task instanceof ObjectiveCCompile) {
                return "ObjectiveC";
            }
            if (task instanceof ObjectiveCppCompile) {
                return "ObjectiveCpp";
            }
            throw new IllegalArgumentException(String.format("Unknown native compile task '%s' (%s).", task.getName(), task.getClass().getSimpleName()));
        });
    }

    private void configureSwiftCompileTask(SwiftCompileTask task) {
        task.getObjectFileDir().convention(this.getLayout().getBuildDirectory().dir(this.names.getOutputDirectoryBase("objs") + "/mainSwift"));
        task.getDebuggable().set((Object)false);
        task.getOptimized().set((Object)false);
        task.getSourceCompatibility().set((Object)SwiftVersion.SWIFT5);
        task.getTargetPlatform().set(this.getTargetPlatform());
        task.getTargetPlatform().finalizeValueOnRead();
        task.getTargetPlatform().disallowChanges();
        task.getToolChain().set(this.selectSwiftToolChain((TargetMachine)this.targetMachine));
        task.getToolChain().finalizeValueOnRead();
        task.getToolChain().disallowChanges();
        task.getModuleName().convention(this.getBaseName().map(this::toModuleName));
        task.getModuleFile().convention(task.getModuleName().flatMap(this::toSwiftModuleFile));
        if (this.targetMachine.getOperatingSystemFamily().isMacOs()) {
            task.getCompilerArgs().add((Object)"-sdk");
            task.getCompilerArgs().add(this.getProviders().provider(() -> ((ProcessBuilderEngine.Handle)CommandLine.of((Object[])new Object[]{"xcrun", "--show-sdk-path"}).execute((CommandLineToolExecutionEngine)new ProcessBuilderEngine())).waitFor().assertNormalExitValue().getStandardOutput().getAsString().trim()));
        }
        if (this instanceof SharedLibraryBinary || this instanceof StaticLibraryBinary) {
            task.getCompilerArgs().add((Object)"-parse-as-library");
        }
    }

    private String toModuleName(String baseName) {
        return GUtil.toCamelCase((CharSequence)baseName);
    }

    private Provider<RegularFile> toSwiftModuleFile(String moduleName) {
        return this.getLayout().getBuildDirectory().file("modules/main/" + moduleName + ".swiftmodule");
    }

    Provider<NativeToolChain> selectNativeToolChain(TargetMachine targetMachine) {
        return this.getProviders().provider(() -> this.toolChainSelector.select(targetMachine));
    }

    private Provider<NativeToolChain> selectSwiftToolChain(TargetMachine targetMachine) {
        return this.getProviders().provider(() -> this.toolChainSelector.selectSwift(targetMachine));
    }

    Provider<NativePlatform> getTargetPlatform() {
        return this.getProviders().provider(() -> NativePlatformFactory.create((TargetMachine)this.targetMachine));
    }

    private ToolType getToolType(Class<? extends Task> taskType) {
        if (CCompileTask.class.isAssignableFrom(taskType)) {
            return ToolType.CPP_COMPILER;
        }
        if (CppCompileTask.class.isAssignableFrom(taskType)) {
            return ToolType.CPP_COMPILER;
        }
        if (ObjectiveCCompileTask.class.isAssignableFrom(taskType)) {
            return ToolType.OBJECTIVEC_COMPILER;
        }
        if (ObjectiveCppCompileTask.class.isAssignableFrom(taskType)) {
            return ToolType.OBJECTIVECPP_COMPILER;
        }
        throw new IllegalArgumentException(String.format("Unknown task type, '%s', cannot choose ToolType.", taskType.getSimpleName()));
    }

    private Callable<List<File>> getSystemIncludes(AbstractNativeCompileTask compileTask) {
        return () -> {
            NativeToolChainInternal toolChain = (NativeToolChainInternal)compileTask.getToolChain().get();
            NativePlatformInternal targetPlatform = (NativePlatformInternal)compileTask.getTargetPlatform().get();
            PlatformToolProvider toolProvider = toolChain.select(targetPlatform);
            return toolProvider.getSystemLibraries(this.getToolType(compileTask.getClass())).getIncludeDirs();
        };
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Override
    public boolean isBuildable() {
        if (!this.compileTasks.withType(AbstractNativeCompileTask.class).get().stream().allMatch(BaseNativeBinary::isBuildable)) {
            return false;
        }
        return this.compileTasks.withType(SwiftCompileTask.class).get().stream().allMatch(BaseNativeBinary::isBuildable);
    }

    private static boolean isBuildable(AbstractNativeCompileTask compileTask) {
        return BaseNativeBinary.isBuildable((NativeToolChain)compileTask.getToolChain().get(), (NativePlatform)compileTask.getTargetPlatform().get());
    }

    private static boolean isBuildable(SwiftCompileTask compileTask) {
        return BaseNativeBinary.isBuildable((NativeToolChain)compileTask.getToolChain().get(), (NativePlatform)compileTask.getTargetPlatform().get());
    }

    protected static boolean isBuildable(NativeToolChain toolchain, NativePlatform platform) {
        NativeToolChainInternal toolchainInternal = (NativeToolChainInternal)toolchain;
        NativePlatformInternal platformInternal = (NativePlatformInternal)platform;
        PlatformToolProvider toolProvider = toolchainInternal.select(platformInternal);
        return toolProvider.isAvailable();
    }

    public abstract Property<String> getBaseName();

    public Object getObjectFiles() {
        Optional<Object> result = this.objectSourceSets.stream().map(GeneratedSourceSet::getAsFileTree).reduce(FileTree::plus).map(it -> it);
        return result.orElseGet(() -> ImmutableList.of());
    }

    private Stream<String> toFrameworkSearchPathFlags(File it) {
        return ImmutableList.of((Object)"-F", (Object)it.getAbsolutePath()).stream();
    }

    @Override
    public TaskView<SourceCompile> getCompileTasks() {
        return this.compileTasks.withType(SourceCompile.class);
    }

    public NamingScheme getNames() {
        return this.names;
    }

    public DefaultTargetMachine getTargetMachine() {
        return this.targetMachine;
    }

    public NativeIncomingDependencies getDependencies() {
        return this.dependencies;
    }
}

