/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal;

import com.google.common.base.Preconditions;
import dev.nokee.language.base.internal.GeneratedSourceSet;
import dev.nokee.language.base.internal.LanguageSourceSetInternal;
import dev.nokee.language.base.internal.SourceSet;
import dev.nokee.language.nativebase.internal.HeaderExportingSourceSet;
import dev.nokee.language.swift.internal.SwiftSourceSet;
import dev.nokee.language.swift.tasks.internal.SwiftCompileTask;
import dev.nokee.platform.base.Variant;
import dev.nokee.platform.base.VariantView;
import dev.nokee.platform.base.internal.BaseComponent;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.base.internal.VariantProvider;
import dev.nokee.platform.nativebase.ExecutableBinary;
import dev.nokee.platform.nativebase.NativeBinary;
import dev.nokee.platform.nativebase.NativeLibrary;
import dev.nokee.platform.nativebase.SharedLibraryBinary;
import dev.nokee.platform.nativebase.StaticLibraryBinary;
import dev.nokee.platform.nativebase.internal.BaseNativeVariant;
import dev.nokee.platform.nativebase.internal.BundleBinaryInternal;
import dev.nokee.platform.nativebase.internal.DefaultBinaryLinkage;
import dev.nokee.platform.nativebase.internal.ExecutableBinaryInternal;
import dev.nokee.platform.nativebase.internal.NativeLanguageRules;
import dev.nokee.platform.nativebase.internal.SharedLibraryBinaryInternal;
import dev.nokee.platform.nativebase.internal.dependencies.AbstractBinaryAwareNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.AbstractNativeComponentDependencies;
import dev.nokee.platform.nativebase.tasks.internal.LinkBundleTask;
import dev.nokee.platform.nativebase.tasks.internal.LinkExecutableTask;
import dev.nokee.platform.nativebase.tasks.internal.LinkSharedLibraryTask;
import dev.nokee.runtime.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public abstract class BaseNativeComponent<T extends Variant>
extends BaseComponent<T> {
    private final Class<T> variantType;

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract TaskContainer getTasks();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    public BaseNativeComponent(NamingScheme names, Class<T> variantType) {
        super(names, variantType);
        Preconditions.checkArgument((boolean)BaseNativeVariant.class.isAssignableFrom(variantType));
        this.variantType = variantType;
        this.getDevelopmentVariant().convention(this.getDefaultVariant());
    }

    public abstract AbstractNativeComponentDependencies getDependencies();

    public VariantView<T> getVariants() {
        return this.getVariantCollection().getAsView(this.variantType);
    }

    protected Provider<T> getDefaultVariant() {
        return this.getProviders().provider(() -> {
            List variants = this.getVariantCollection().get().stream().map(it -> {
                Preconditions.checkArgument((boolean)(it instanceof BaseNativeVariant));
                return (BaseNativeVariant)((Object)((Object)it));
            }).filter(it -> {
                DefaultOperatingSystemFamily osFamily = (DefaultOperatingSystemFamily)it.getBuildVariant().getAxisValue(DefaultOperatingSystemFamily.DIMENSION_TYPE);
                DefaultMachineArchitecture architecture = (DefaultMachineArchitecture)it.getBuildVariant().getAxisValue(DefaultMachineArchitecture.DIMENSION_TYPE);
                return DefaultOperatingSystemFamily.HOST.equals((Object)osFamily) && DefaultMachineArchitecture.HOST.equals((Object)architecture);
            }).collect(Collectors.toList());
            if (variants.isEmpty()) {
                return null;
            }
            return (Variant)BaseNativeComponent.one(variants);
        });
    }

    public static <T> T one(Iterable<T> c) {
        Iterator<T> iterator = c.iterator();
        Preconditions.checkArgument((boolean)iterator.hasNext(), (Object)"collection needs to have one element, was empty");
        T result = iterator.next();
        Preconditions.checkArgument((!iterator.hasNext() ? 1 : 0) != 0, (Object)"collection needs to only have one element, more than one element found");
        return result;
    }

    protected abstract T createVariant(String var1, BuildVariant var2, AbstractBinaryAwareNativeComponentDependencies var3);

    protected AbstractBinaryAwareNativeComponentDependencies newDependencies(NamingScheme names, BuildVariant buildVariant) {
        AbstractNativeComponentDependencies variantDependencies = this.getDependencies();
        if (((Set)this.getBuildVariants().get()).size() > 1) {
            variantDependencies = variantDependencies.extendsWith(names);
        }
        return variantDependencies.newVariantDependency(names, buildVariant, !this.getSourceCollection().withType(SwiftSourceSet.class).isEmpty());
    }

    public void finalizeExtension(Project project) {
        ((Set)this.getBuildVariants().get()).forEach(buildVariant -> {
            DefaultTargetMachine targetMachineInternal = new DefaultTargetMachine((DefaultOperatingSystemFamily)buildVariant.getAxisValue(DefaultOperatingSystemFamily.DIMENSION_TYPE), (DefaultMachineArchitecture)buildVariant.getAxisValue(DefaultMachineArchitecture.DIMENSION_TYPE));
            NamingScheme names = this.getNames().forBuildVariant(buildVariant, (Collection)this.getBuildVariants().get());
            AbstractBinaryAwareNativeComponentDependencies dependencies = this.newDependencies(names.withComponentDisplayName("main native component"), (BuildVariant)buildVariant);
            VariantProvider variant = this.getVariantCollection().registerVariant(buildVariant, (name, bv) -> {
                T it = this.createVariant(name, bv, dependencies);
                DomainObjectSet<GeneratedSourceSet> objectSourceSets = ((NativeLanguageRules)this.getObjects().newInstance(NativeLanguageRules.class, new Object[]{names})).apply((DomainObjectSet<SourceSet>)this.getSourceCollection());
                BaseNativeVariant variantInternal = (BaseNativeVariant)((Object)((Object)((Object)it)));
                if (buildVariant.hasAxisValue(DefaultBinaryLinkage.DIMENSION_TYPE)) {
                    DefaultBinaryLinkage linkage = (DefaultBinaryLinkage)buildVariant.getAxisValue(DefaultBinaryLinkage.DIMENSION_TYPE);
                    if (linkage.equals(DefaultBinaryLinkage.EXECUTABLE)) {
                        TaskProvider linkTask = this.getTasks().register(names.getTaskName("link"), LinkExecutableTask.class);
                        ExecutableBinaryInternal binary = (ExecutableBinaryInternal)this.getObjects().newInstance(ExecutableBinaryInternal.class, new Object[]{names, objectSourceSets, targetMachineInternal, linkTask, dependencies.getIncoming()});
                        variantInternal.getBinaryCollection().add((Object)binary);
                        binary.getBaseName().convention((Object)project.getName());
                    } else if (linkage.equals(DefaultBinaryLinkage.SHARED)) {
                        TaskProvider linkTask = this.getTasks().register(names.getTaskName("link"), LinkSharedLibraryTask.class);
                        SharedLibraryBinaryInternal binary = (SharedLibraryBinaryInternal)this.getObjects().newInstance(SharedLibraryBinaryInternal.class, new Object[]{names, this.getObjects().domainObjectSet(LanguageSourceSetInternal.class), targetMachineInternal, objectSourceSets, linkTask, dependencies.getIncoming()});
                        variantInternal.getBinaryCollection().add((Object)binary);
                        binary.getBaseName().convention((Object)project.getName());
                    } else if (linkage.equals(DefaultBinaryLinkage.BUNDLE)) {
                        TaskProvider linkTask = this.getTasks().register(names.getTaskName("link"), LinkBundleTask.class);
                        BundleBinaryInternal binary = (BundleBinaryInternal)this.getObjects().newInstance(BundleBinaryInternal.class, new Object[]{names, targetMachineInternal, objectSourceSets, linkTask, dependencies.getIncoming()});
                        variantInternal.getBinaryCollection().add((Object)binary);
                        binary.getBaseName().convention((Object)project.getName());
                    }
                }
                return it;
            });
            this.onEachVariantDependencies(variant, dependencies);
            this.getTasks().register(names.getTaskName("objects"), task -> {
                task.setGroup("build");
                task.setDescription("Assembles main objects.");
                task.dependsOn(new Object[]{variant.map(it -> it.getBinaries().withType(ExecutableBinary.class).map(ExecutableBinary::getCompileTasks))});
                task.dependsOn(new Object[]{variant.map(it -> it.getBinaries().withType(SharedLibraryBinary.class).map(SharedLibraryBinary::getCompileTasks))});
                task.dependsOn(new Object[]{variant.map(it -> it.getBinaries().withType(StaticLibraryBinary.class).map(NativeBinary::getCompileTasks))});
            });
            this.onEachVariant((BuildVariant)buildVariant, (VariantProvider<T>)variant, names);
            if (((Set)this.getBuildVariants().get()).size() > 1) {
                this.getTasks().register(names.getTaskName("assemble"), task -> {
                    task.dependsOn(new Object[]{variant.flatMap(Variant::getDevelopmentBinary)});
                    task.setGroup("build");
                });
            }
        });
        this.getTasks().named("assemble", task -> task.dependsOn(new Object[]{this.getDevelopmentVariant().flatMap(Variant::getDevelopmentBinary)}));
        this.getVariantCollection().disallowChanges();
    }

    protected void onEachVariantDependencies(VariantProvider<T> variant, AbstractBinaryAwareNativeComponentDependencies dependencies) {
        if (NativeLibrary.class.isAssignableFrom(this.variantType)) {
            if (!this.getSourceCollection().withType(SwiftSourceSet.class).isEmpty()) {
                dependencies.getOutgoing().getExportedSwiftModule().convention(variant.flatMap(it -> {
                    List result = (List)it.getBinaries().withType(NativeBinary.class).flatMap(binary -> {
                        List modules = (List)binary.getCompileTasks().withType(SwiftCompileTask.class).map(task -> task.getModuleFile()).get();
                        return modules;
                    }).get();
                    return (Provider)BaseNativeComponent.one(result);
                }));
            }
            if (!this.getSourceCollection().matching(it -> it instanceof HeaderExportingSourceSet).isEmpty()) {
                dependencies.getOutgoing().getExportedHeaders().convention(this.getLayout().getProjectDirectory().dir("src/main/public"));
            }
        }
        dependencies.getOutgoing().getExportedBinary().convention(variant.flatMap(it -> it.getDevelopmentBinary()));
    }

    protected void onEachVariant(BuildVariant buildVariant, VariantProvider<T> variant, NamingScheme names) {
        if (buildVariant.hasAxisValue(DefaultBinaryLinkage.DIMENSION_TYPE)) {
            DefaultBinaryLinkage linkage = (DefaultBinaryLinkage)buildVariant.getAxisValue(DefaultBinaryLinkage.DIMENSION_TYPE);
            if (linkage.equals(DefaultBinaryLinkage.SHARED)) {
                this.getTasks().register(names.getTaskName("sharedLibrary"), task -> {
                    task.setGroup("build");
                    task.setDescription("Assembles a shared library binary containing the main objects.");
                    task.dependsOn(new Object[]{variant.map(it -> ((SharedLibraryBinary)it.getDevelopmentBinary().get()).getLinkTask())});
                });
            } else if (linkage.equals(DefaultBinaryLinkage.STATIC)) {
                this.getTasks().register(names.getTaskName("staticLibrary"), task -> {
                    task.setGroup("build");
                    task.setDescription("Assembles a static library binary containing the main objects.");
                    task.dependsOn(new Object[]{variant.map(it -> ((StaticLibraryBinary)it.getDevelopmentBinary().get()).getCreateTask())});
                });
            } else if (linkage.equals(DefaultBinaryLinkage.EXECUTABLE)) {
                this.getTasks().register(names.getTaskName("executable"), task -> {
                    task.setGroup("build");
                    task.setDescription("Assembles a executable binary containing the main objects.");
                    task.dependsOn(new Object[]{variant.map(it -> ((ExecutableBinary)it.getDevelopmentBinary().get()).getLinkTask())});
                });
            }
        }
    }
}

