/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal;

import com.google.common.collect.ImmutableList;
import dev.nokee.platform.base.Binary;
import dev.nokee.platform.base.BinaryView;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.DefaultBuildVariant;
import dev.nokee.platform.nativebase.TargetMachineAwareComponent;
import dev.nokee.platform.nativebase.internal.BaseNativeComponent;
import dev.nokee.platform.nativebase.internal.DefaultBinaryLinkage;
import dev.nokee.platform.nativebase.internal.DefaultNativeApplicationComponent;
import dev.nokee.platform.nativebase.internal.DefaultNativeLibraryComponent;
import dev.nokee.platform.nativebase.internal.DefaultTargetMachineFactory;
import dev.nokee.runtime.base.internal.Dimension;
import dev.nokee.runtime.nativebase.TargetMachine;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;

public abstract class BaseNativeExtension<T extends BaseNativeComponent<?>> {
    private final T component;

    public BaseNativeExtension(T component) {
        this.component = component;
        component.getBuildVariants().convention(this.getProviders().provider(this::createBuildVariants));
        component.getBuildVariants().finalizeValueOnRead();
        component.getBuildVariants().disallowChanges();
        component.getDimensions().disallowChanges();
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    protected Iterable<BuildVariant> createBuildVariants() {
        if (this instanceof TargetMachineAwareComponent) {
            Set targetMachines = (Set)((TargetMachineAwareComponent)((Object)this)).getTargetMachines().get();
            ImmutableList.Builder buildVariantBuilder = ImmutableList.builder();
            for (TargetMachine targetMachine : targetMachines) {
                DefaultTargetMachine targetMachineInternal = (DefaultTargetMachine)targetMachine;
                ImmutableList.Builder dimensionBuilder = ImmutableList.builder();
                dimensionBuilder.add((Object[])new Dimension[]{targetMachineInternal.getOperatingSystemFamily(), targetMachineInternal.getArchitecture()});
                if (this.component instanceof DefaultNativeApplicationComponent) {
                    dimensionBuilder.add((Object)DefaultBinaryLinkage.EXECUTABLE);
                    buildVariantBuilder.add((Object)DefaultBuildVariant.of((Iterable)dimensionBuilder.build()));
                    continue;
                }
                if (this.component instanceof DefaultNativeLibraryComponent) {
                    dimensionBuilder.add((Object)DefaultBinaryLinkage.SHARED);
                    buildVariantBuilder.add((Object)DefaultBuildVariant.of((Iterable)dimensionBuilder.build()));
                    continue;
                }
                buildVariantBuilder.add((Object)DefaultBuildVariant.of((Iterable)dimensionBuilder.build()));
            }
            return buildVariantBuilder.build();
        }
        throw new GradleException("Not able to create the default build variants");
    }

    protected T getComponent() {
        return this.component;
    }

    public DefaultTargetMachineFactory getMachines() {
        return DefaultTargetMachineFactory.INSTANCE;
    }

    public BinaryView<Binary> getBinaries() {
        return this.component.getBinaries();
    }
}

