/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal;

import com.google.common.base.Preconditions;
import dev.nokee.platform.base.Binary;
import dev.nokee.platform.base.internal.BaseVariant;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.nativebase.internal.DefaultBinaryLinkage;
import dev.nokee.platform.nativebase.internal.ExecutableBinaryInternal;
import dev.nokee.platform.nativebase.internal.SharedLibraryBinaryInternal;
import dev.nokee.platform.nativebase.internal.StaticLibraryBinaryInternal;
import java.util.Iterator;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public abstract class BaseNativeVariant
extends BaseVariant {
    private final NamingScheme names;

    public BaseNativeVariant(String name, NamingScheme names, BuildVariant buildVariant) {
        super(name, buildVariant);
        this.names = names;
        this.getDevelopmentBinary().convention(this.getDefaultBinary());
    }

    @Inject
    protected abstract TaskContainer getTasks();

    @Inject
    protected abstract ProviderFactory getProviders();

    public TaskProvider<Task> getAssembleTask() {
        return this.getTasks().named(this.names.getTaskName("assemble"));
    }

    protected Provider<Binary> getDefaultBinary() {
        return this.getProviders().provider(() -> {
            DefaultBinaryLinkage linkage = (DefaultBinaryLinkage)this.getBuildVariant().getAxisValue(DefaultBinaryLinkage.DIMENSION_TYPE);
            if (linkage.equals(DefaultBinaryLinkage.EXECUTABLE)) {
                return (Binary)BaseNativeVariant.one(this.getBinaryCollection().withType(ExecutableBinaryInternal.class));
            }
            if (linkage.equals(DefaultBinaryLinkage.SHARED)) {
                return (Binary)BaseNativeVariant.one(this.getBinaryCollection().withType(SharedLibraryBinaryInternal.class));
            }
            if (linkage.equals(DefaultBinaryLinkage.STATIC)) {
                return (Binary)BaseNativeVariant.one(this.getBinaryCollection().withType(StaticLibraryBinaryInternal.class));
            }
            return null;
        });
    }

    protected static <T> T one(Iterable<T> c) {
        Iterator<T> iterator = c.iterator();
        Preconditions.checkArgument((boolean)iterator.hasNext(), (Object)"collection needs to have one element, was empty");
        T result = iterator.next();
        Preconditions.checkArgument((!iterator.hasNext() ? 1 : 0) != 0, (Object)"collection needs to only have one element, more than one element found");
        return result;
    }

    public NamingScheme getNames() {
        return this.names;
    }
}

