/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal;

import com.google.common.collect.ImmutableSet;
import dev.nokee.language.base.internal.GeneratedSourceSet;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.nativebase.BundleBinary;
import dev.nokee.platform.nativebase.internal.BaseNativeBinary;
import dev.nokee.platform.nativebase.internal.OperatingSystemOperations;
import dev.nokee.platform.nativebase.internal.dependencies.NativeIncomingDependencies;
import dev.nokee.platform.nativebase.tasks.LinkBundle;
import dev.nokee.platform.nativebase.tasks.internal.LinkBundleTask;
import dev.nokee.runtime.nativebase.OperatingSystemFamily;
import dev.nokee.runtime.nativebase.TargetMachine;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import javax.inject.Inject;
import org.gradle.api.Buildable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;

public abstract class BundleBinaryInternal
extends BaseNativeBinary
implements BundleBinary,
Buildable {
    private final TaskProvider<LinkBundleTask> linkTask;

    @Inject
    public BundleBinaryInternal(NamingScheme names, DefaultTargetMachine targetMachine, DomainObjectSet<GeneratedSourceSet> objectSourceSets, TaskProvider<LinkBundleTask> linkTask, NativeIncomingDependencies dependencies) {
        super(names, objectSourceSets, targetMachine, dependencies);
        this.linkTask = linkTask;
        linkTask.configure(this::configureBundleTask);
    }

    @Inject
    protected abstract TaskContainer getTasks();

    private void configureBundleTask(LinkBundleTask task) {
        task.setDescription("Links the bundle.");
        task.source(this.getObjectFiles());
        task.getTargetPlatform().set(this.getTargetPlatform());
        task.getTargetPlatform().finalizeValueOnRead();
        task.getTargetPlatform().disallowChanges();
        task.getDebuggable().set((Object)false);
        task.getDestinationDirectory().convention(this.getLayout().getBuildDirectory().dir(this.getNames().getOutputDirectoryBase("libs")));
        task.getLinkedFile().convention(this.getBundleLinkedFile());
        task.getLinkerArgs().addAll((Object[])new String[]{"-Xlinker", "-bundle"});
        task.getToolChain().set(this.selectNativeToolChain((TargetMachine)this.getTargetMachine()));
        task.getToolChain().finalizeValueOnRead();
        task.getToolChain().disallowChanges();
    }

    private Provider<RegularFile> getBundleLinkedFile() {
        return this.getLayout().getBuildDirectory().file(this.getBaseName().map(it -> {
            DefaultOperatingSystemFamily osFamily = this.getTargetMachine().getOperatingSystemFamily();
            OperatingSystemOperations osOperations = OperatingSystemOperations.of((OperatingSystemFamily)osFamily);
            return osOperations.getExecutableName(this.getNames().getOutputDirectoryBase("libs") + "/" + it);
        }));
    }

    public TaskDependency getBuildDependencies() {
        return task -> ImmutableSet.of((Object)((LinkBundle)this.getLinkTask().get()));
    }

    @Override
    public TaskProvider<LinkBundle> getLinkTask() {
        return this.getTasks().named(this.linkTask.getName(), LinkBundle.class);
    }
}

