/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import dev.nokee.runtime.nativebase.internal.LibraryElements;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Cast;
import org.gradle.language.cpp.CppBinary;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;

public abstract class ConfigurationUtils {
    public DescribableConfigurationAction asBucket() {
        return new DescribableConfigurationAction(ConfigurationSpec.asBucket());
    }

    public DescribableConfigurationAction asBucket(Configuration fromBucket) {
        return new DescribableConfigurationAction(ConfigurationSpec.asBucket(fromBucket));
    }

    public IncomingConfigurationAction asIncomingHeaderSearchPath() {
        return (IncomingConfigurationAction)this.getObjects().newInstance(IncomingConfigurationAction.class, new Object[]{ConfigurationSpec.asIncoming().withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().put((Object)Usage.USAGE_ATTRIBUTE, (Object)this.getObjects().named(Usage.class, "cplusplus-api")).build())});
    }

    public IncomingConfigurationAction asIncomingHeaderSearchPathFrom(Configuration ... fromBuckets) {
        return (IncomingConfigurationAction)this.getObjects().newInstance(IncomingConfigurationAction.class, new Object[]{ConfigurationSpec.asIncoming(fromBuckets).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().put((Object)Usage.USAGE_ATTRIBUTE, (Object)this.getObjects().named(Usage.class, "cplusplus-api")).build())});
    }

    public IncomingConfigurationAction asIncomingSwiftModuleFrom(Configuration ... fromBuckets) {
        return (IncomingConfigurationAction)this.getObjects().newInstance(IncomingConfigurationAction.class, new Object[]{ConfigurationSpec.asIncoming(fromBuckets).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().put((Object)Usage.USAGE_ATTRIBUTE, (Object)this.getObjects().named(Usage.class, "swift-api")).build())});
    }

    public IncomingConfigurationAction asIncomingLinkLibrariesFrom(Configuration ... fromBuckets) {
        return (IncomingConfigurationAction)this.getObjects().newInstance(IncomingConfigurationAction.class, new Object[]{ConfigurationSpec.asIncoming(fromBuckets).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().put((Object)Usage.USAGE_ATTRIBUTE, (Object)this.getObjects().named(Usage.class, "native-link")).build())});
    }

    public IncomingConfigurationAction asIncomingRuntimeLibrariesFrom(Configuration ... fromBucket) {
        return (IncomingConfigurationAction)this.getObjects().newInstance(IncomingConfigurationAction.class, new Object[]{ConfigurationSpec.asIncoming(fromBucket).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().put((Object)Usage.USAGE_ATTRIBUTE, (Object)this.getObjects().named(Usage.class, "native-runtime")).build())});
    }

    public VariantAwareOutgoingConfigurationAction asOutgoingHeaderSearchPathFrom(Configuration ... fromBuckets) {
        return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{ConfigurationSpec.asOutgoing(fromBuckets).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.of((Object)Usage.USAGE_ATTRIBUTE, (Object)this.getObjects().named(Usage.class, "cplusplus-api")))});
    }

    public VariantAwareOutgoingConfigurationAction asOutgoingSwiftModuleFrom(Configuration ... fromBuckets) {
        return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{ConfigurationSpec.asOutgoing(fromBuckets).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.of((Object)Usage.USAGE_ATTRIBUTE, (Object)this.getObjects().named(Usage.class, "swift-api")))});
    }

    public VariantAwareOutgoingConfigurationAction asOutgoingLinkLibrariesFrom(Configuration ... fromBuckets) {
        return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{ConfigurationSpec.asOutgoing(fromBuckets).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.of((Object)Usage.USAGE_ATTRIBUTE, (Object)this.getObjects().named(Usage.class, "native-link")))});
    }

    public VariantAwareOutgoingConfigurationAction asOutgoingRuntimeLibrariesFrom(Configuration ... fromBuckets) {
        return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{ConfigurationSpec.asOutgoing(fromBuckets).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.of((Object)Usage.USAGE_ATTRIBUTE, (Object)this.getObjects().named(Usage.class, "native-runtime")))});
    }

    public static void configureAsIncoming(Configuration configuration) {
        configuration.setCanBeConsumed(false);
        configuration.setCanBeResolved(true);
    }

    public static void configureAsOutgoing(Configuration configuration) {
        configuration.setCanBeConsumed(true);
        configuration.setCanBeResolved(false);
    }

    public static void configureAsBucket(Configuration configuration) {
        configuration.setCanBeConsumed(false);
        configuration.setCanBeResolved(false);
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    public static final class ConfigurationSpec
    implements Action<Configuration> {
        private final Type type;
        private final List<Configuration> fromBuckets;
        private final Map<Attribute<?>, Object> attributes;
        private final OutgoingArtifact artifact;
        private final Action<Configuration> additionalAction;
        private final String description;

        static ConfigurationSpec asBucket() {
            return new ConfigurationSpec(Type.BUCKET, (List<Configuration>)ImmutableList.of(), Collections.emptyMap(), null, (Action<Configuration>)((Action)it -> {}), null);
        }

        static ConfigurationSpec asBucket(Configuration fromBucket) {
            return new ConfigurationSpec(Type.BUCKET, (List<Configuration>)ImmutableList.of((Object)fromBucket), Collections.emptyMap(), null, (Action<Configuration>)((Action)it -> {}), null);
        }

        static ConfigurationSpec asOutgoing(Configuration ... fromBuckets) {
            return new ConfigurationSpec(Type.OUTGOING, (List<Configuration>)ImmutableList.copyOf((Object[])fromBuckets), Collections.emptyMap(), null, (Action<Configuration>)((Action)it -> {}), null);
        }

        static ConfigurationSpec asIncoming() {
            return new ConfigurationSpec(Type.INCOMING, (List<Configuration>)ImmutableList.of(), Collections.emptyMap(), null, (Action<Configuration>)((Action)it -> {}), null);
        }

        static ConfigurationSpec asIncoming(Configuration ... fromBucket) {
            return new ConfigurationSpec(Type.INCOMING, (List<Configuration>)ImmutableList.copyOf((Object[])fromBucket), Collections.emptyMap(), null, (Action<Configuration>)((Action)it -> {}), null);
        }

        public void execute(Configuration configuration) {
            this.type.configure(configuration);
            configuration.setExtendsFrom(this.fromBuckets);
            if (this.description != null) {
                configuration.setDescription(this.description);
            }
            this.attributes.forEach((key, value) -> configuration.getAttributes().attribute((Attribute)Cast.uncheckedNonnullCast((Object)key), Cast.uncheckedNonnullCast((Object)value)));
            if (this.artifact != null) {
                configuration.getOutgoing().artifact(this.artifact.notation, it -> {
                    if (this.artifact.type != null) {
                        it.setType(this.artifact.type);
                    }
                });
            }
            this.additionalAction.execute((Object)configuration);
        }

        public ConfigurationSpec(Type type, List<Configuration> fromBuckets, Map<Attribute<?>, Object> attributes, OutgoingArtifact artifact, Action<Configuration> additionalAction, String description) {
            this.type = type;
            this.fromBuckets = fromBuckets;
            this.attributes = attributes;
            this.artifact = artifact;
            this.additionalAction = additionalAction;
            this.description = description;
        }

        public Type getType() {
            return this.type;
        }

        public List<Configuration> getFromBuckets() {
            return this.fromBuckets;
        }

        public Map<Attribute<?>, Object> getAttributes() {
            return this.attributes;
        }

        public OutgoingArtifact getArtifact() {
            return this.artifact;
        }

        public Action<Configuration> getAdditionalAction() {
            return this.additionalAction;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigurationSpec)) {
                return false;
            }
            ConfigurationSpec other = (ConfigurationSpec)o;
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            List<Configuration> this$fromBuckets = this.getFromBuckets();
            List<Configuration> other$fromBuckets = other.getFromBuckets();
            if (this$fromBuckets == null ? other$fromBuckets != null : !((Object)this$fromBuckets).equals(other$fromBuckets)) {
                return false;
            }
            Map<Attribute<?>, Object> this$attributes = this.getAttributes();
            Map<Attribute<?>, Object> other$attributes = other.getAttributes();
            if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
                return false;
            }
            OutgoingArtifact this$artifact = this.getArtifact();
            OutgoingArtifact other$artifact = other.getArtifact();
            if (this$artifact == null ? other$artifact != null : !((Object)this$artifact).equals(other$artifact)) {
                return false;
            }
            Action<Configuration> this$additionalAction = this.getAdditionalAction();
            Action<Configuration> other$additionalAction = other.getAdditionalAction();
            if (this$additionalAction == null ? other$additionalAction != null : !this$additionalAction.equals(other$additionalAction)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            List<Configuration> $fromBuckets = this.getFromBuckets();
            result = result * 59 + ($fromBuckets == null ? 43 : ((Object)$fromBuckets).hashCode());
            Map<Attribute<?>, Object> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            OutgoingArtifact $artifact = this.getArtifact();
            result = result * 59 + ($artifact == null ? 43 : ((Object)$artifact).hashCode());
            Action<Configuration> $additionalAction = this.getAdditionalAction();
            result = result * 59 + ($additionalAction == null ? 43 : $additionalAction.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigurationUtils.ConfigurationSpec(type=" + (Object)((Object)this.getType()) + ", fromBuckets=" + this.getFromBuckets() + ", attributes=" + this.getAttributes() + ", artifact=" + this.getArtifact() + ", additionalAction=" + this.getAdditionalAction() + ", description=" + this.getDescription() + ")";
        }

        public ConfigurationSpec withAttributes(Map<Attribute<?>, Object> attributes) {
            return this.attributes == attributes ? this : new ConfigurationSpec(this.type, this.fromBuckets, attributes, this.artifact, this.additionalAction, this.description);
        }

        public ConfigurationSpec withArtifact(OutgoingArtifact artifact) {
            return this.artifact == artifact ? this : new ConfigurationSpec(this.type, this.fromBuckets, this.attributes, artifact, this.additionalAction, this.description);
        }

        public ConfigurationSpec withAdditionalAction(Action<Configuration> additionalAction) {
            return this.additionalAction == additionalAction ? this : new ConfigurationSpec(this.type, this.fromBuckets, this.attributes, this.artifact, additionalAction, this.description);
        }

        public ConfigurationSpec withDescription(String description) {
            return this.description == description ? this : new ConfigurationSpec(this.type, this.fromBuckets, this.attributes, this.artifact, this.additionalAction, description);
        }

        static enum Type {
            BUCKET(ConfigurationUtils::configureAsBucket),
            INCOMING(ConfigurationUtils::configureAsIncoming),
            OUTGOING(ConfigurationUtils::configureAsOutgoing);

            private final Consumer<Configuration> action;

            private Type(Consumer<Configuration> action) {
                this.action = action;
            }

            void configure(Configuration configuration) {
                this.action.accept(configuration);
            }
        }
    }

    public static final class OutgoingArtifact {
        private final String type;
        private final Object notation;

        public OutgoingArtifact(String type, Object notation) {
            this.type = type;
            this.notation = notation;
        }

        public String getType() {
            return this.type;
        }

        public Object getNotation() {
            return this.notation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OutgoingArtifact)) {
                return false;
            }
            OutgoingArtifact other = (OutgoingArtifact)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Object this$notation = this.getNotation();
            Object other$notation = other.getNotation();
            return !(this$notation == null ? other$notation != null : !this$notation.equals(other$notation));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Object $notation = this.getNotation();
            result = result * 59 + ($notation == null ? 43 : $notation.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigurationUtils.OutgoingArtifact(type=" + this.getType() + ", notation=" + this.getNotation() + ")";
        }
    }

    public static abstract class VariantAwareOutgoingConfigurationAction
    extends DescribableConfigurationAction {
        @Inject
        public VariantAwareOutgoingConfigurationAction(ConfigurationSpec spec) {
            super(spec);
        }

        @Inject
        protected abstract ObjectFactory getObjects();

        public VariantAwareOutgoingConfigurationAction withStaticLinkage() {
            return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{this.spec.withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)CppBinary.LINKAGE_ATTRIBUTE, (Object)Linkage.STATIC).build())});
        }

        public VariantAwareOutgoingConfigurationAction withSharedLinkage() {
            return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{this.spec.withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)CppBinary.LINKAGE_ATTRIBUTE, (Object)Linkage.SHARED).build())});
        }

        public VariantAwareOutgoingConfigurationAction asDebug() {
            return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{this.spec.withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)Boolean.TRUE).put((Object)CppBinary.OPTIMIZED_ATTRIBUTE, (Object)Boolean.FALSE).build())});
        }

        public VariantAwareOutgoingConfigurationAction asRelease() {
            return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{this.spec.withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)Boolean.TRUE).put((Object)CppBinary.OPTIMIZED_ATTRIBUTE, (Object)Boolean.TRUE).build())});
        }

        public VariantAwareOutgoingConfigurationAction frameworkArtifact(Object notation) {
            return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{this.spec.withArtifact(new OutgoingArtifact("framework", notation)).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)this.getObjects().named(LibraryElements.class, "framework-bundle")).build())});
        }

        public VariantAwareOutgoingConfigurationAction headerDirectoryArtifact(Object notation) {
            return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{this.spec.withArtifact(new OutgoingArtifact("directory", notation)).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)this.getObjects().named(LibraryElements.class, "headers-cplusplus")).build())});
        }

        public VariantAwareOutgoingConfigurationAction sharedLibraryArtifact(Object notation) {
            return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{this.spec.withArtifact(new OutgoingArtifact(null, notation)).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)this.getObjects().named(LibraryElements.class, "dynamic-lib")).build())});
        }

        public VariantAwareOutgoingConfigurationAction staticLibraryArtifact(Object notation) {
            return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{this.spec.withArtifact(new OutgoingArtifact(null, notation)).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)this.getObjects().named(LibraryElements.class, "link-archive")).build())});
        }

        public VariantAwareOutgoingConfigurationAction importLibraryArtifact(Object notation) {
            return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{this.spec.withArtifact(new OutgoingArtifact(null, notation)).withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)this.getObjects().named(LibraryElements.class, "import-lib")).build())});
        }

        public VariantAwareOutgoingConfigurationAction andThen(Action<Configuration> additionalAction) {
            return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{this.spec.withAdditionalAction(additionalAction)});
        }

        @Override
        public VariantAwareOutgoingConfigurationAction withDescription(String description) {
            return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{this.spec.withDescription(description)});
        }

        public VariantAwareOutgoingConfigurationAction forTargetMachine(DefaultTargetMachine targetMachine) {
            return (VariantAwareOutgoingConfigurationAction)this.getObjects().newInstance(VariantAwareOutgoingConfigurationAction.class, new Object[]{this.spec.withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)this.getObjects().named(OperatingSystemFamily.class, targetMachine.getOperatingSystemFamily().getName())).put((Object)MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)this.getObjects().named(MachineArchitecture.class, targetMachine.getArchitecture().getName())).build())});
        }
    }

    public static abstract class IncomingConfigurationAction
    extends DescribableConfigurationAction {
        @Inject
        public IncomingConfigurationAction(ConfigurationSpec spec) {
            super(spec);
        }

        @Inject
        protected abstract ObjectFactory getObjects();

        public IncomingConfigurationAction asDebug() {
            return (IncomingConfigurationAction)this.getObjects().newInstance(IncomingConfigurationAction.class, new Object[]{this.spec.withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)Boolean.TRUE).put((Object)CppBinary.OPTIMIZED_ATTRIBUTE, (Object)Boolean.FALSE).build())});
        }

        public IncomingConfigurationAction asRelease() {
            return (IncomingConfigurationAction)this.getObjects().newInstance(IncomingConfigurationAction.class, new Object[]{this.spec.withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)Boolean.TRUE).put((Object)CppBinary.OPTIMIZED_ATTRIBUTE, (Object)Boolean.TRUE).build())});
        }

        public IncomingConfigurationAction forTargetMachine(DefaultTargetMachine targetMachine) {
            return (IncomingConfigurationAction)this.getObjects().newInstance(IncomingConfigurationAction.class, new Object[]{this.spec.withAttributes((Map<Attribute<?>, Object>)ImmutableMap.builder().putAll(this.spec.attributes).put((Object)OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)this.getObjects().named(OperatingSystemFamily.class, targetMachine.getOperatingSystemFamily().getName())).put((Object)MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)this.getObjects().named(MachineArchitecture.class, targetMachine.getArchitecture().getName())).build())});
        }

        @Override
        public IncomingConfigurationAction withDescription(String description) {
            return (IncomingConfigurationAction)this.getObjects().newInstance(IncomingConfigurationAction.class, new Object[]{this.spec.withDescription(description)});
        }
    }

    public static class DescribableConfigurationAction
    implements Action<Configuration> {
        protected final ConfigurationSpec spec;

        public DescribableConfigurationAction(ConfigurationSpec spec) {
            this.spec = spec;
        }

        public DescribableConfigurationAction withDescription(String description) {
            return new DescribableConfigurationAction(this.spec.withDescription(description));
        }

        public void execute(Configuration configuration) {
            this.spec.execute(configuration);
        }
    }
}

