/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal;

import dev.nokee.platform.nativebase.TargetMachineBuilder;
import dev.nokee.platform.nativebase.TargetMachineFactory;
import dev.nokee.runtime.nativebase.TargetMachine;
import dev.nokee.runtime.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import lombok.NonNull;

public class DefaultTargetMachineFactory
implements TargetMachineFactory {
    public static final DefaultTargetMachineFactory INSTANCE = new DefaultTargetMachineFactory();

    @Override
    public TargetMachineBuilder getWindows() {
        return new DefaultTargetMachineBuilder(DefaultOperatingSystemFamily.WINDOWS, DefaultMachineArchitecture.HOST);
    }

    @Override
    public TargetMachineBuilder getLinux() {
        return new DefaultTargetMachineBuilder(DefaultOperatingSystemFamily.LINUX, DefaultMachineArchitecture.HOST);
    }

    @Override
    public TargetMachineBuilder getMacOS() {
        return new DefaultTargetMachineBuilder(DefaultOperatingSystemFamily.MACOS, DefaultMachineArchitecture.HOST);
    }

    @Override
    public TargetMachineBuilder getFreeBSD() {
        return new DefaultTargetMachineBuilder(DefaultOperatingSystemFamily.FREE_BSD, DefaultMachineArchitecture.HOST);
    }

    public static DefaultTargetMachine host() {
        return new DefaultTargetMachine(DefaultOperatingSystemFamily.HOST, DefaultMachineArchitecture.HOST);
    }

    public TargetMachineBuilder os(String name) {
        return new DefaultTargetMachineBuilder(new DefaultOperatingSystemFamily(name), DefaultMachineArchitecture.HOST);
    }

    private static class DefaultTargetMachineBuilder
    extends DefaultTargetMachine
    implements TargetMachineBuilder {
        public DefaultTargetMachineBuilder(@NonNull DefaultOperatingSystemFamily operatingSystemFamily, @NonNull DefaultMachineArchitecture architecture) {
            super(operatingSystemFamily, architecture);
            if (operatingSystemFamily == null) {
                throw new NullPointerException("operatingSystemFamily is marked non-null but is null");
            }
            if (architecture == null) {
                throw new NullPointerException("architecture is marked non-null but is null");
            }
        }

        @Override
        public TargetMachine getX86() {
            return new DefaultTargetMachine(this.getOperatingSystemFamily(), DefaultMachineArchitecture.X86);
        }

        @Override
        public TargetMachine getX86_64() {
            return new DefaultTargetMachine(this.getOperatingSystemFamily(), DefaultMachineArchitecture.X86_64);
        }

        public TargetMachine architecture(String name) {
            return new DefaultTargetMachine(this.getOperatingSystemFamily(), (DefaultMachineArchitecture)new DefaultMachineArchitecture.UnknownMachineArchitecture(name));
        }
    }
}

