/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.nokee.core.exec.CommandLine;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.ProcessBuilderEngine;
import dev.nokee.language.base.internal.GeneratedSourceSet;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.nativebase.ExecutableBinary;
import dev.nokee.platform.nativebase.internal.BaseNativeBinary;
import dev.nokee.platform.nativebase.internal.OperatingSystemOperations;
import dev.nokee.platform.nativebase.internal.dependencies.NativeIncomingDependencies;
import dev.nokee.platform.nativebase.tasks.LinkExecutable;
import dev.nokee.platform.nativebase.tasks.internal.LinkExecutableTask;
import dev.nokee.runtime.nativebase.OperatingSystemFamily;
import dev.nokee.runtime.nativebase.TargetMachine;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import java.io.File;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.Buildable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.nativeplatform.toolchain.Swiftc;

public abstract class ExecutableBinaryInternal
extends BaseNativeBinary
implements ExecutableBinary,
Buildable {
    private final TaskProvider<LinkExecutableTask> linkTask;

    @Inject
    public ExecutableBinaryInternal(NamingScheme names, DomainObjectSet<GeneratedSourceSet> objectSourceSets, DefaultTargetMachine targetMachine, TaskProvider<LinkExecutableTask> linkTask, NativeIncomingDependencies dependencies) {
        super(names, objectSourceSets, targetMachine, dependencies);
        this.linkTask = linkTask;
        linkTask.configure(this::configureExecutableTask);
        linkTask.configure(task -> {
            task.getLibs().from(new Object[]{dependencies.getLinkLibraries()});
            task.getLinkerArgs().addAll(this.getProviders().provider(() -> dependencies.getLinkFrameworks().getFiles().stream().flatMap(this::toFrameworkFlags).collect(Collectors.toList())));
            task.getLinkerArgs().addAll(task.getToolChain().map(it -> {
                if (it instanceof Swiftc && targetMachine.getOperatingSystemFamily().isMacOs()) {
                    return ImmutableList.of((Object)"-sdk", (Object)((ProcessBuilderEngine.Handle)CommandLine.of((Object[])new Object[]{"xcrun", "--show-sdk-path"}).execute((CommandLineToolExecutionEngine)new ProcessBuilderEngine())).waitFor().assertNormalExitValue().getStandardOutput().getAsString().trim());
                }
                return ImmutableList.of();
            }));
        });
    }

    private Stream<String> toFrameworkFlags(File it) {
        return ImmutableList.of((Object)"-F", (Object)it.getParent(), (Object)"-framework", (Object)FilenameUtils.removeExtension((String)it.getName())).stream();
    }

    private void configureExecutableTask(LinkExecutableTask task) {
        task.setDescription("Links the executable.");
        task.source(this.getObjectFiles());
        task.getTargetPlatform().set(this.getTargetPlatform());
        task.getTargetPlatform().finalizeValueOnRead();
        task.getTargetPlatform().disallowChanges();
        task.getDebuggable().set((Object)false);
        task.getDestinationDirectory().convention(this.getLayout().getBuildDirectory().dir(this.getNames().getOutputDirectoryBase("exes")));
        task.getLinkedFile().convention(this.getExecutableLinkedFile());
        task.getToolChain().set(this.selectNativeToolChain((TargetMachine)this.getTargetMachine()));
        task.getToolChain().finalizeValueOnRead();
        task.getToolChain().disallowChanges();
    }

    private Provider<RegularFile> getExecutableLinkedFile() {
        return this.getLayout().getBuildDirectory().file(this.getBaseName().map(it -> {
            DefaultOperatingSystemFamily osFamily = this.getTargetMachine().getOperatingSystemFamily();
            OperatingSystemOperations osOperations = OperatingSystemOperations.of((OperatingSystemFamily)osFamily);
            return osOperations.getExecutableName(this.getNames().getOutputDirectoryBase("exes") + "/" + it);
        }));
    }

    @Inject
    protected abstract TaskContainer getTasks();

    @Override
    public TaskProvider<LinkExecutable> getLinkTask() {
        return this.getTasks().named(this.linkTask.getName(), LinkExecutable.class);
    }

    public TaskDependency getBuildDependencies() {
        return task -> ImmutableSet.of((Object)((LinkExecutable)this.getLinkTask().get()));
    }
}

