/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal;

import dev.nokee.language.base.internal.GeneratedSourceSet;
import dev.nokee.language.base.internal.SourceSet;
import dev.nokee.language.c.internal.CSourceSet;
import dev.nokee.language.c.internal.tasks.CCompileTask;
import dev.nokee.language.cpp.internal.CppSourceSet;
import dev.nokee.language.cpp.internal.tasks.CppCompileTask;
import dev.nokee.language.nativebase.internal.UTTypeObjectCode;
import dev.nokee.language.objectivec.internal.ObjectiveCSourceSet;
import dev.nokee.language.objectivec.internal.tasks.ObjectiveCCompileTask;
import dev.nokee.language.objectivecpp.internal.ObjectiveCppSourceSet;
import dev.nokee.language.objectivecpp.internal.tasks.ObjectiveCppCompileTask;
import dev.nokee.language.swift.internal.SwiftSourceSet;
import dev.nokee.language.swift.tasks.internal.SwiftCompileTask;
import dev.nokee.platform.base.internal.NamingScheme;
import java.util.function.Function;
import javax.inject.Inject;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.language.swift.tasks.SwiftCompile;

public abstract class NativeLanguageRules {
    private final NamingScheme names;

    @Inject
    public NativeLanguageRules(NamingScheme names) {
        this.names = names;
    }

    @Inject
    protected abstract TaskContainer getTasks();

    @Inject
    protected abstract ObjectFactory getObjects();

    public DomainObjectSet<GeneratedSourceSet> apply(DomainObjectSet<SourceSet> sourceSets) {
        DomainObjectSet objectSourceSets = this.getObjects().domainObjectSet(GeneratedSourceSet.class);
        sourceSets.withType(CSourceSet.class).stream().map(this.createNativeCompileTask("C", CCompileTask.class)).map(this::newObjectSourceSetFromNativeCompileTask).forEach(arg_0 -> objectSourceSets.add(arg_0));
        sourceSets.withType(CppSourceSet.class).stream().map(this.createNativeCompileTask("Cpp", CppCompileTask.class)).map(this::newObjectSourceSetFromNativeCompileTask).forEach(arg_0 -> objectSourceSets.add(arg_0));
        sourceSets.withType(ObjectiveCSourceSet.class).stream().map(this.createNativeCompileTask("ObjectiveC", ObjectiveCCompileTask.class)).map(this::newObjectSourceSetFromNativeCompileTask).forEach(arg_0 -> objectSourceSets.add(arg_0));
        sourceSets.withType(ObjectiveCppSourceSet.class).stream().map(this.createNativeCompileTask("ObjectiveCpp", ObjectiveCppCompileTask.class)).map(this::newObjectSourceSetFromNativeCompileTask).forEach(arg_0 -> objectSourceSets.add(arg_0));
        sourceSets.withType(SwiftSourceSet.class).stream().map(this::createSwiftCompileTask).map(this::newObjectSourceSetFromSwiftCompileTask).forEach(arg_0 -> objectSourceSets.add(arg_0));
        return objectSourceSets;
    }

    private <T extends AbstractNativeCompileTask> Function<SourceSet, TaskProvider<T>> createNativeCompileTask(String languageName, Class<T> type) {
        return sourceSet -> this.getTasks().register(this.getNames().getTaskName("compile", languageName), type, task -> task.getSource().from(new Object[]{sourceSet.getAsFileTree()}));
    }

    private TaskProvider<SwiftCompileTask> createSwiftCompileTask(SourceSet sourceSet) {
        return this.getTasks().register(this.getNames().getTaskName("compile", "Swift"), SwiftCompileTask.class, task -> task.getSource().from(new Object[]{sourceSet.getAsFileTree()}));
    }

    private <T extends AbstractNativeCompileTask> GeneratedSourceSet newObjectSourceSetFromNativeCompileTask(TaskProvider<T> task) {
        return (GeneratedSourceSet)this.getObjects().newInstance(GeneratedSourceSet.class, new Object[]{new UTTypeObjectCode(), task.flatMap(AbstractNativeCompileTask::getObjectFileDir), task});
    }

    private GeneratedSourceSet newObjectSourceSetFromSwiftCompileTask(TaskProvider<SwiftCompileTask> task) {
        return (GeneratedSourceSet)this.getObjects().newInstance(GeneratedSourceSet.class, new Object[]{new UTTypeObjectCode(), task.flatMap(SwiftCompile::getObjectFileDir), task});
    }

    public NamingScheme getNames() {
        return this.names;
    }
}

