/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal;

import dev.nokee.runtime.nativebase.OperatingSystemFamily;
import org.gradle.internal.os.OperatingSystem;

public class OperatingSystemOperations {
    private final OperatingSystem osInternal;

    public OperatingSystemOperations(OperatingSystem osInternal) {
        this.osInternal = osInternal;
    }

    public static OperatingSystemOperations of(OperatingSystemFamily osFamily) {
        if (osFamily.isWindows()) {
            return new OperatingSystemOperations((OperatingSystem)OperatingSystem.WINDOWS);
        }
        if (osFamily.isMacOS()) {
            return new OperatingSystemOperations((OperatingSystem)OperatingSystem.MAC_OS);
        }
        if (osFamily.isLinux()) {
            return new OperatingSystemOperations((OperatingSystem)OperatingSystem.LINUX);
        }
        if (osFamily.isFreeBSD()) {
            return new OperatingSystemOperations((OperatingSystem)OperatingSystem.FREE_BSD);
        }
        if (osFamily.isiOS()) {
            return new OperatingSystemOperations((OperatingSystem)OperatingSystem.MAC_OS);
        }
        return new OperatingSystemOperations((OperatingSystem)OperatingSystem.LINUX);
    }

    public String getSharedLibraryName(String libraryName) {
        return this.osInternal.getSharedLibraryName(libraryName);
    }

    public String getStaticLibraryName(String libraryName) {
        return this.osInternal.getStaticLibraryName(libraryName);
    }

    public String getExecutableName(String executableName) {
        return this.osInternal.getExecutableName(executableName);
    }
}

