/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.nokee.core.exec.CommandLine;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.ProcessBuilderEngine;
import dev.nokee.language.base.internal.GeneratedSourceSet;
import dev.nokee.language.base.internal.LanguageSourceSetInternal;
import dev.nokee.language.nativebase.HeaderSearchPath;
import dev.nokee.language.nativebase.internal.DefaultHeaderSearchPath;
import dev.nokee.language.nativebase.internal.HeaderExportingSourceSetInternal;
import dev.nokee.language.nativebase.tasks.internal.NativeSourceCompileTask;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.nativebase.SharedLibraryBinary;
import dev.nokee.platform.nativebase.internal.BaseNativeBinary;
import dev.nokee.platform.nativebase.internal.NativePlatformFactory;
import dev.nokee.platform.nativebase.internal.OperatingSystemOperations;
import dev.nokee.platform.nativebase.internal.dependencies.NativeIncomingDependencies;
import dev.nokee.platform.nativebase.tasks.LinkSharedLibrary;
import dev.nokee.platform.nativebase.tasks.internal.LinkSharedLibraryTask;
import dev.nokee.runtime.nativebase.OperatingSystemFamily;
import dev.nokee.runtime.nativebase.TargetMachine;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.Buildable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.Swiftc;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.util.GUtil;

public abstract class SharedLibraryBinaryInternal
extends BaseNativeBinary
implements SharedLibraryBinary,
Buildable {
    private final TaskProvider<LinkSharedLibraryTask> linkTask;
    private final NativeIncomingDependencies dependencies;
    private final DomainObjectSet<? super LanguageSourceSetInternal> sources;

    @Inject
    public SharedLibraryBinaryInternal(NamingScheme names, DomainObjectSet<LanguageSourceSetInternal> parentSources, DefaultTargetMachine targetMachine, DomainObjectSet<GeneratedSourceSet> objectSourceSets, TaskProvider<LinkSharedLibraryTask> linkTask, NativeIncomingDependencies dependencies) {
        super(names, objectSourceSets, targetMachine, dependencies);
        this.linkTask = linkTask;
        this.dependencies = dependencies;
        this.sources = this.getObjects().domainObjectSet(LanguageSourceSetInternal.class);
        parentSources.all(it -> this.sources.add(it));
        this.compileTasks.configureEach(AbstractNativeCompileTask.class, task -> {
            AbstractNativeCompileTask softwareModelTaskInternal = task;
            NativeSourceCompileTask taskInternal = (NativeSourceCompileTask)task;
            taskInternal.getHeaderSearchPaths().addAll(softwareModelTaskInternal.getIncludes().getElements().map(SharedLibraryBinaryInternal::toHeaderSearchPaths));
            this.sources.withType(HeaderExportingSourceSetInternal.class, sourceSet -> softwareModelTaskInternal.getIncludes().from(new Object[]{sourceSet.getSource()}));
            task.getIncludes().from(new Object[]{"src/main/public"});
            softwareModelTaskInternal.getIncludes().from(new Object[]{this.getJvmIncludes()});
        });
        linkTask.configure(task -> {
            task.getLibs().from(new Object[]{dependencies.getLinkLibraries()});
            task.getLinkerArgs().addAll(this.getProviders().provider(() -> dependencies.getLinkFrameworks().getFiles().stream().flatMap(this::toFrameworkFlags).collect(Collectors.toList())));
            task.getLinkerArgs().addAll(task.getToolChain().map(it -> {
                if (it instanceof Swiftc && targetMachine.getOperatingSystemFamily().isMacOs()) {
                    return ImmutableList.of((Object)"-sdk", (Object)((ProcessBuilderEngine.Handle)CommandLine.of((Object[])new Object[]{"xcrun", "--show-sdk-path"}).execute((CommandLineToolExecutionEngine)new ProcessBuilderEngine())).waitFor().assertNormalExitValue().getStandardOutput().getAsString().trim());
                }
                return ImmutableList.of();
            }));
            task.getLinkerArgs().addAll(task.getToolChain().map(it -> {
                if (it instanceof Swiftc) {
                    return ImmutableList.of((Object)"-module-name", (Object)this.toModuleName((String)this.getBaseName().get()));
                }
                return ImmutableList.of();
            }));
        });
        linkTask.configure(this::configureSharedLibraryTask);
        this.getLinkedFile().set(linkTask.flatMap(AbstractLinkTask::getLinkedFile));
        this.getLinkedFile().disallowChanges();
    }

    private String toModuleName(String baseName) {
        return GUtil.toCamelCase((CharSequence)baseName);
    }

    @Override
    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Override
    @Inject
    protected abstract ObjectFactory getObjects();

    private void configureSharedLibraryTask(LinkSharedLibraryTask task) {
        task.setDescription("Links the shared library.");
        task.source(this.getObjectFiles());
        task.getTargetPlatform().set(this.getTargetPlatform());
        task.getTargetPlatform().finalizeValueOnRead();
        task.getTargetPlatform().disallowChanges();
        task.getDebuggable().set((Object)false);
        Provider installName = task.getLinkedFile().getLocationOnly().map(linkedFile -> linkedFile.getAsFile().getName());
        task.getInstallName().set(installName);
        task.getDestinationDirectory().convention(this.getLayout().getBuildDirectory().dir(this.getNames().getOutputDirectoryBase("libs")));
        task.getLinkedFile().convention(this.getSharedLibraryLinkedFile());
        task.getImportLibrary().convention(this.getImportLibraryFile((Provider<PlatformToolProvider>)task.getToolChain().map(this.selectToolProvider((TargetMachine)this.getTargetMachine()))));
        task.getToolChain().set(this.selectNativeToolChain((TargetMachine)this.getTargetMachine()));
        task.getToolChain().finalizeValueOnRead();
        task.getToolChain().disallowChanges();
    }

    private Transformer<PlatformToolProvider, NativeToolChain> selectToolProvider(TargetMachine targetMachine) {
        return toolChain -> {
            NativeToolChainInternal toolChainInternal = (NativeToolChainInternal)toolChain;
            return toolChainInternal.select(NativePlatformFactory.create(targetMachine));
        };
    }

    private Provider<RegularFile> getImportLibraryFile(Provider<PlatformToolProvider> platformToolProvider) {
        return this.getProviders().provider(() -> {
            PlatformToolProvider toolProvider = (PlatformToolProvider)platformToolProvider.get();
            if (toolProvider.producesImportLibrary()) {
                return (RegularFile)this.getLayout().getBuildDirectory().file(toolProvider.getImportLibraryName(this.getNames().getOutputDirectoryBase("libs") + "/" + (String)this.getBaseName().get())).get();
            }
            return null;
        });
    }

    private Provider<RegularFile> getSharedLibraryLinkedFile() {
        return this.getLayout().getBuildDirectory().file(this.getBaseName().map(it -> {
            DefaultOperatingSystemFamily osFamily = this.getTargetMachine().getOperatingSystemFamily();
            OperatingSystemOperations osOperations = OperatingSystemOperations.of((OperatingSystemFamily)osFamily);
            return osOperations.getSharedLibraryName(this.getNames().getOutputDirectoryBase("libs") + "/" + it);
        }));
    }

    @Override
    public TaskProvider<LinkSharedLibrary> getLinkTask() {
        return this.getTasks().named(this.linkTask.getName(), LinkSharedLibrary.class);
    }

    @Inject
    protected abstract ProviderFactory getProviderFactory();

    @Inject
    protected abstract TaskContainer getTasks();

    public abstract RegularFileProperty getLinkedFile();

    @Override
    public boolean isBuildable() {
        return super.isBuildable() && SharedLibraryBinaryInternal.isBuildable((LinkSharedLibrary)this.linkTask.get());
    }

    private static boolean isBuildable(LinkSharedLibrary linkTask) {
        AbstractLinkTask linkTaskInternal = (AbstractLinkTask)linkTask;
        return SharedLibraryBinaryInternal.isBuildable((NativeToolChain)linkTaskInternal.getToolChain().get(), (NativePlatform)linkTaskInternal.getTargetPlatform().get());
    }

    private static List<HeaderSearchPath> toHeaderSearchPaths(Set<FileSystemLocation> paths) {
        return paths.stream().map(FileSystemLocation::getAsFile).map(DefaultHeaderSearchPath::new).collect(Collectors.toList());
    }

    private Provider<List<File>> getJvmIncludes() {
        return this.getProviderFactory().provider(() -> {
            ArrayList<File> result = new ArrayList<File>();
            result.add(new File(Jvm.current().getJavaHome().getAbsolutePath() + "/include"));
            if (OperatingSystem.current().isMacOsX()) {
                result.add(new File(Jvm.current().getJavaHome().getAbsolutePath() + "/include/darwin"));
            } else if (OperatingSystem.current().isLinux()) {
                result.add(new File(Jvm.current().getJavaHome().getAbsolutePath() + "/include/linux"));
            } else if (OperatingSystem.current().isWindows()) {
                result.add(new File(Jvm.current().getJavaHome().getAbsolutePath() + "/include/win32"));
            }
            return result;
        });
    }

    private Stream<String> toFrameworkFlags(File it) {
        return ImmutableList.of((Object)"-F", (Object)it.getParent(), (Object)"-framework", (Object)FilenameUtils.removeExtension((String)it.getName())).stream();
    }

    public TaskDependency getBuildDependencies() {
        return task -> ImmutableSet.of((Object)((LinkSharedLibrary)this.getLinkTask().get()));
    }

    public FileCollection getRuntimeLibrariesDependencies() {
        return this.dependencies.getRuntimeLibraries();
    }
}

