/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal;

import dev.nokee.platform.nativebase.internal.NativePlatformFactory;
import dev.nokee.runtime.nativebase.TargetMachine;
import dev.nokee.runtime.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeLanguage;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppToolChain;
import org.gradle.nativeplatform.toolchain.internal.swift.SwiftcToolChain;
import org.gradle.platform.base.Platform;

public class ToolChainSelectorInternal {
    private final ModelRegistry modelRegistry;
    private final NativePlatformFactory nativePlatformFactory = new NativePlatformFactory();

    @Inject
    public ToolChainSelectorInternal(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public boolean isKnown(TargetMachine targetMachine) {
        return this.getToolChains().stream().anyMatch(it -> it.knows(targetMachine));
    }

    public boolean canBuild(TargetMachine targetMachine) {
        return this.getToolChains().stream().anyMatch(it -> it.canBuild(targetMachine));
    }

    public NativeToolChainInternal select(TargetMachine targetMachine) {
        NativePlatformInternal targetPlatform = NativePlatformFactory.create(targetMachine);
        NativeToolChainRegistryInternal registry = (NativeToolChainRegistryInternal)this.modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class);
        NativeToolChainInternal toolChain = (NativeToolChainInternal)registry.getForPlatform((Platform)targetPlatform);
        toolChain.assertSupported();
        return toolChain;
    }

    public NativeToolChainInternal selectSwift(TargetMachine targetMachine) {
        NativePlatformInternal targetPlatform = NativePlatformFactory.create(targetMachine);
        if (targetMachine.getOperatingSystemFamily().equals(DefaultOperatingSystemFamily.IOS)) {
            targetPlatform = DefaultNativePlatform.host();
        }
        NativeToolChainRegistryInternal registry = (NativeToolChainRegistryInternal)this.modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class);
        NativeToolChainInternal toolChain = registry.getForPlatform(NativeLanguage.SWIFT, targetPlatform);
        toolChain.assertSupported();
        return toolChain;
    }

    private Collection<ToolChain> getToolChains() {
        ArrayList<ToolChain> result = new ArrayList<ToolChain>();
        result.add(new DomainKnowledgeToolChain());
        result.addAll(((NativeToolChainRegistryInternal)this.modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class)).withType(NativeToolChainInternal.class).stream().map(x$0 -> new SoftwareModelToolChain((NativeToolChainInternal)x$0)).collect(Collectors.toList()));
        return result;
    }

    private static class DomainKnowledgeToolChain
    implements ToolChain {
        private DomainKnowledgeToolChain() {
        }

        @Override
        public boolean knows(TargetMachine targetMachine) {
            return (DomainKnowledgeToolChain.isTargetingLinuxButNotLinux(targetMachine) || DomainKnowledgeToolChain.isTargetingMacOsButNotMacOs(targetMachine) || DomainKnowledgeToolChain.isTargetingFreeBsdButNotFreeBsd(targetMachine) || DomainKnowledgeToolChain.isTargetingWindowsButNotWindows(targetMachine)) && DomainKnowledgeToolChain.isKnownArchitecture(targetMachine);
        }

        private static boolean isKnownArchitecture(TargetMachine targetMachine) {
            return Arrays.asList(DefaultMachineArchitecture.X86, DefaultMachineArchitecture.X86_64).contains(targetMachine.getArchitecture());
        }

        private static boolean isTargetingMacOsButNotMacOs(TargetMachine targetMachine) {
            return targetMachine.getOperatingSystemFamily().isMacOs() && !OperatingSystem.current().isMacOsX();
        }

        private static boolean isTargetingLinuxButNotLinux(TargetMachine targetMachine) {
            return targetMachine.getOperatingSystemFamily().isLinux() && !SystemUtils.IS_OS_LINUX;
        }

        private static boolean isTargetingFreeBsdButNotFreeBsd(TargetMachine targetMachine) {
            return targetMachine.getOperatingSystemFamily().isFreeBSD() && !SystemUtils.IS_OS_FREE_BSD;
        }

        private static boolean isTargetingWindowsButNotWindows(TargetMachine targetMachine) {
            return targetMachine.getOperatingSystemFamily().isWindows() && !SystemUtils.IS_OS_WINDOWS;
        }

        @Override
        public boolean canBuild(TargetMachine targetMachine) {
            return DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(((DefaultOperatingSystemFamily)targetMachine.getOperatingSystemFamily()).getName());
        }
    }

    private class SoftwareModelToolChain
    implements ToolChain {
        private final NativeToolChainInternal delegate;

        private SoftwareModelToolChain(NativeToolChainInternal delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean knows(TargetMachine targetMachine) {
            PlatformToolProvider toolProvider;
            ToolChainSelectorInternal.this.nativePlatformFactory;
            NativePlatformInternal targetPlatform = NativePlatformFactory.create(targetMachine);
            NativeLanguage nativeLanguage = NativeLanguage.CPP;
            if (this.delegate instanceof SwiftcToolChain) {
                nativeLanguage = NativeLanguage.SWIFT;
            }
            if ((toolProvider = this.delegate.select(nativeLanguage, targetPlatform)).isAvailable()) {
                return true;
            }
            return toolProvider.isSupported() && (targetPlatform.getOperatingSystem().isWindows() || !(this.delegate instanceof VisualCppToolChain));
        }

        @Override
        public boolean canBuild(TargetMachine targetMachine) {
            PlatformToolProvider toolProvider;
            ToolChainSelectorInternal.this.nativePlatformFactory;
            NativePlatformInternal targetPlatform = NativePlatformFactory.create(targetMachine);
            NativeLanguage nativeLanguage = NativeLanguage.CPP;
            if (this.delegate instanceof SwiftcToolChain) {
                nativeLanguage = NativeLanguage.SWIFT;
            }
            return (toolProvider = this.delegate.select(nativeLanguage, targetPlatform)).isAvailable();
        }
    }

    private static interface ToolChain {
        public boolean knows(TargetMachine var1);

        public boolean canBuild(TargetMachine var1);
    }
}

