/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal.dependencies;

import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.nativebase.internal.ConfigurationUtils;
import dev.nokee.platform.nativebase.internal.dependencies.AbstractBinaryAwareNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.DependencyBucket;
import dev.nokee.platform.nativebase.internal.dependencies.NativeDependencyBucket;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.model.ObjectFactory;

public abstract class AbstractNativeComponentDependencies {
    private final DependencyBucket implementation;
    private final DependencyBucket compileOnly;
    private final DependencyBucket linkOnly;
    private final DependencyBucket runtimeOnly;

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    protected AbstractNativeComponentDependencies(NamingScheme names) {
        ConfigurationUtils builder = (ConfigurationUtils)this.getObjects().newInstance(ConfigurationUtils.class, new Object[0]);
        this.implementation = (DependencyBucket)this.getObjects().newInstance(NativeDependencyBucket.class, new Object[]{this.getConfigurations().create(names.getConfigurationName("implementation"), (Action)builder.asBucket().withDescription(names.getConfigurationDescription("Implementation only dependencies for %s.")))});
        String compileOnlyName = names.getConfigurationName("compileOnly");
        this.compileOnly = compileOnlyName.contains("native") || compileOnlyName.contains("Native") ? null : (DependencyBucket)this.getObjects().newInstance(NativeDependencyBucket.class, new Object[]{this.getConfigurations().create(compileOnlyName, (Action)builder.asBucket().withDescription(names.getConfigurationDescription("Compile only dependencies for %s.")))});
        this.linkOnly = (DependencyBucket)this.getObjects().newInstance(NativeDependencyBucket.class, new Object[]{this.getConfigurations().create(names.getConfigurationName("linkOnly"), (Action)builder.asBucket().withDescription(names.getConfigurationDescription("Link only dependencies for %s.")))});
        this.runtimeOnly = (DependencyBucket)this.getObjects().newInstance(NativeDependencyBucket.class, new Object[]{this.getConfigurations().create(names.getConfigurationName("runtimeOnly"), (Action)builder.asBucket().withDescription(names.getConfigurationDescription("Runtime only dependencies for %s.")))});
    }

    public void implementation(Object notation) {
        this.implementation.addDependency(notation);
    }

    public void implementation(Object notation, Action<? super ModuleDependency> action) {
        this.implementation.addDependency(notation, action);
    }

    public void compileOnly(Object notation) {
        this.compileOnly.addDependency(notation);
    }

    public void compileOnly(Object notation, Action<? super ModuleDependency> action) {
        this.compileOnly.addDependency(notation, action);
    }

    public void linkOnly(Object notation) {
        this.linkOnly.addDependency(notation);
    }

    public void linkOnly(Object notation, Action<? super ModuleDependency> action) {
        this.linkOnly.addDependency(notation, action);
    }

    public void runtimeOnly(Object notation) {
        this.runtimeOnly.addDependency(notation);
    }

    public void runtimeOnly(Object notation, Action<? super ModuleDependency> action) {
        this.runtimeOnly.addDependency(notation, action);
    }

    public Configuration getImplementationDependencies() {
        return this.implementation.getAsConfiguration();
    }

    public Configuration getCompileOnlyDependencies() {
        if (this.compileOnly == null) {
            return null;
        }
        return this.compileOnly.getAsConfiguration();
    }

    public Configuration getLinkOnlyDependencies() {
        return this.linkOnly.getAsConfiguration();
    }

    public Configuration getRuntimeOnlyDependencies() {
        return this.runtimeOnly.getAsConfiguration();
    }

    public abstract AbstractNativeComponentDependencies extendsWith(NamingScheme var1);

    public abstract AbstractBinaryAwareNativeComponentDependencies newVariantDependency(NamingScheme var1, BuildVariant var2, boolean var3);
}

