/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal.dependencies;

import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.nativebase.internal.ConfigurationUtils;
import dev.nokee.platform.nativebase.internal.dependencies.AbstractNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.HeaderIncomingDependencies;
import dev.nokee.runtime.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import dev.nokee.runtime.nativebase.internal.DependencyUtils;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public abstract class DefaultHeaderIncomingDependencies
implements HeaderIncomingDependencies {
    private final Configuration headerSearchPathsConfiguration;

    @Inject
    public DefaultHeaderIncomingDependencies(NamingScheme names, AbstractNativeComponentDependencies buckets, BuildVariant buildVariant) {
        ConfigurationUtils configurationUtils = (ConfigurationUtils)this.getObjects().newInstance(ConfigurationUtils.class, new Object[0]);
        DefaultTargetMachine targetMachine = new DefaultTargetMachine((DefaultOperatingSystemFamily)buildVariant.getAxisValue(DefaultOperatingSystemFamily.DIMENSION_TYPE), (DefaultMachineArchitecture)buildVariant.getAxisValue(DefaultMachineArchitecture.DIMENSION_TYPE));
        String name = names.getConfigurationNameWithoutPrefix("headerSearchPaths");
        this.headerSearchPathsConfiguration = buckets.getCompileOnlyDependencies() == null ? (Configuration)this.getConfigurations().create(name, (Action)configurationUtils.asIncomingHeaderSearchPathFrom(buckets.getImplementationDependencies()).forTargetMachine(targetMachine).withDescription(names.getConfigurationDescription("Header search paths for %s."))) : (Configuration)this.getConfigurations().create(name, (Action)configurationUtils.asIncomingHeaderSearchPathFrom(buckets.getImplementationDependencies(), buckets.getCompileOnlyDependencies()).forTargetMachine(targetMachine).withDescription(names.getConfigurationDescription("Header search paths for %s.")));
        this.configureNativeCompilerInputs();
    }

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Override
    public FileCollection getHeaderSearchPaths() {
        return this.getObjects().fileCollection().from(new Object[]{this.getNativeCompilerInputs().map(this::toHeaderSearchPaths)}).builtBy(new Object[]{this.headerSearchPathsConfiguration});
    }

    @Override
    public FileCollection getFrameworkSearchPaths() {
        return this.getObjects().fileCollection().from(new Object[]{this.getNativeCompilerInputs().map(this::toFrameworkSearchPaths)}).builtBy(new Object[]{this.headerSearchPathsConfiguration});
    }

    private void configureNativeCompilerInputs() {
        this.getNativeCompilerInputs().set(this.fromNativeCompileConfiguration());
        this.getNativeCompilerInputs().finalizeValueOnRead();
        this.getNativeCompilerInputs().disallowChanges();
    }

    protected abstract ListProperty<CompilerInput> getNativeCompilerInputs();

    private Provider<List<CompilerInput>> fromNativeCompileConfiguration() {
        return this.getProviders().provider(() -> this.headerSearchPathsConfiguration.getIncoming().getArtifacts().getArtifacts().stream().map(CompilerInput::of).collect(Collectors.toList()));
    }

    private List<File> toHeaderSearchPaths(List<CompilerInput> inputs) {
        return inputs.stream().filter(it -> !it.isFramework()).map(CompilerInput::getFile).collect(Collectors.toList());
    }

    private List<File> toFrameworkSearchPaths(List<CompilerInput> inputs) {
        return inputs.stream().filter(it -> it.isFramework()).map(it -> it.getFile().getParentFile()).collect(Collectors.toList());
    }

    public static final class CompilerInput {
        private final boolean framework;
        private final File file;

        public static CompilerInput of(ResolvedArtifactResult result) {
            return new CompilerInput(DependencyUtils.isFrameworkDependency((ResolvedArtifactResult)result), result.getFile());
        }

        public CompilerInput(boolean framework, File file) {
            this.framework = framework;
            this.file = file;
        }

        public boolean isFramework() {
            return this.framework;
        }

        public File getFile() {
            return this.file;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilerInput)) {
                return false;
            }
            CompilerInput other = (CompilerInput)o;
            if (this.isFramework() != other.isFramework()) {
                return false;
            }
            File this$file = this.getFile();
            File other$file = other.getFile();
            return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFramework() ? 79 : 97);
            File $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            return result;
        }

        public String toString() {
            return "DefaultHeaderIncomingDependencies.CompilerInput(framework=" + this.isFramework() + ", file=" + this.getFile() + ")";
        }
    }
}

