/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal.dependencies;

import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.nativebase.internal.ConfigurationUtils;
import dev.nokee.platform.nativebase.internal.dependencies.AbstractNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.SwiftModuleIncomingDependencies;
import dev.nokee.runtime.nativebase.internal.DependencyUtils;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public abstract class DefaultSwiftModuleIncomingDependencies
implements SwiftModuleIncomingDependencies {
    private final Configuration importSwiftModulesConfiguration;

    @Inject
    public DefaultSwiftModuleIncomingDependencies(NamingScheme names, AbstractNativeComponentDependencies buckets) {
        ConfigurationUtils configurationUtils = (ConfigurationUtils)this.getObjects().newInstance(ConfigurationUtils.class, new Object[0]);
        String name = names.getConfigurationNameWithoutPrefix("importSwiftModules");
        this.importSwiftModulesConfiguration = (Configuration)this.getConfigurations().create(name, (Action)configurationUtils.asIncomingSwiftModuleFrom(buckets.getImplementationDependencies(), buckets.getCompileOnlyDependencies()).withDescription(names.getConfigurationDescription("Import Swift modules for %s.")));
        this.configureSwiftCompilerInputs();
    }

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Override
    public FileCollection getSwiftModules() {
        return this.getObjects().fileCollection().from(new Object[]{this.getSwiftCompilerInputs().map(this::toSwiftModules)}).builtBy(new Object[]{this.importSwiftModulesConfiguration});
    }

    @Override
    public FileCollection getFrameworkSearchPaths() {
        return this.getObjects().fileCollection().from(new Object[]{this.getSwiftCompilerInputs().map(this::toFrameworkSearchPaths)}).builtBy(new Object[]{this.importSwiftModulesConfiguration});
    }

    private List<File> toSwiftModules(List<CompilerInput> inputs) {
        return inputs.stream().filter(it -> !it.isFramework()).map(CompilerInput::getFile).collect(Collectors.toList());
    }

    private List<File> toFrameworkSearchPaths(List<CompilerInput> inputs) {
        return inputs.stream().filter(it -> it.isFramework()).map(it -> it.getFile().getParentFile()).collect(Collectors.toList());
    }

    private void configureSwiftCompilerInputs() {
        this.getSwiftCompilerInputs().set(this.fromSwiftCompileConfiguration());
        this.getSwiftCompilerInputs().finalizeValueOnRead();
        this.getSwiftCompilerInputs().disallowChanges();
    }

    protected abstract ListProperty<CompilerInput> getSwiftCompilerInputs();

    private Provider<List<CompilerInput>> fromSwiftCompileConfiguration() {
        return this.getProviders().provider(() -> this.importSwiftModulesConfiguration.getIncoming().getArtifacts().getArtifacts().stream().map(CompilerInput::of).collect(Collectors.toList()));
    }

    public static final class CompilerInput {
        private final boolean framework;
        private final File file;

        public static CompilerInput of(ResolvedArtifactResult result) {
            return new CompilerInput(DependencyUtils.isFrameworkDependency((ResolvedArtifactResult)result), result.getFile());
        }

        public CompilerInput(boolean framework, File file) {
            this.framework = framework;
            this.file = file;
        }

        public boolean isFramework() {
            return this.framework;
        }

        public File getFile() {
            return this.file;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilerInput)) {
                return false;
            }
            CompilerInput other = (CompilerInput)o;
            if (this.isFramework() != other.isFramework()) {
                return false;
            }
            File this$file = this.getFile();
            File other$file = other.getFile();
            return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFramework() ? 79 : 97);
            File $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            return result;
        }

        public String toString() {
            return "DefaultSwiftModuleIncomingDependencies.CompilerInput(framework=" + this.isFramework() + ", file=" + this.getFile() + ")";
        }
    }
}

