/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.nativebase.internal.dependencies;

import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.nativebase.internal.ConfigurationUtils;
import dev.nokee.platform.nativebase.internal.dependencies.AbstractNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.HeaderIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.SwiftModuleIncomingDependencies;
import dev.nokee.runtime.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import dev.nokee.runtime.nativebase.internal.DefaultTargetMachine;
import dev.nokee.runtime.nativebase.internal.DependencyUtils;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public abstract class NativeIncomingDependencies {
    private final SwiftModuleIncomingDependencies incomingSwiftModules;
    private final HeaderIncomingDependencies incomingHeaders;
    private final Configuration runtimeLibrariesConfiguration;
    private final Configuration linkLibrariesConfiguration;

    @Inject
    public NativeIncomingDependencies(NamingScheme names, BuildVariant buildVariant, AbstractNativeComponentDependencies buckets, SwiftModuleIncomingDependencies incomingSwiftModules, HeaderIncomingDependencies incomingHeaders) {
        DefaultTargetMachine targetMachine = new DefaultTargetMachine((DefaultOperatingSystemFamily)buildVariant.getAxisValue(DefaultOperatingSystemFamily.DIMENSION_TYPE), (DefaultMachineArchitecture)buildVariant.getAxisValue(DefaultMachineArchitecture.DIMENSION_TYPE));
        this.incomingSwiftModules = incomingSwiftModules;
        this.incomingHeaders = incomingHeaders;
        ConfigurationUtils configurationUtils = (ConfigurationUtils)this.getObjects().newInstance(ConfigurationUtils.class, new Object[0]);
        this.linkLibrariesConfiguration = (Configuration)this.getConfigurations().create(names.getConfigurationName("linkLibraries"), (Action)configurationUtils.asIncomingLinkLibrariesFrom(buckets.getImplementationDependencies(), buckets.getLinkOnlyDependencies()).forTargetMachine(targetMachine).asDebug().withDescription(names.getConfigurationDescription("Link libraries for %s.")));
        this.runtimeLibrariesConfiguration = (Configuration)this.getConfigurations().create(names.getConfigurationName("runtimeLibraries"), (Action)configurationUtils.asIncomingRuntimeLibrariesFrom(buckets.getImplementationDependencies(), buckets.getRuntimeOnlyDependencies()).forTargetMachine(targetMachine).asDebug().withDescription(names.getConfigurationDescription("Runtime libraries for %s.")));
        this.configureLinkerInputs();
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    @Inject
    protected abstract ProviderFactory getProviders();

    public FileCollection getSwiftModules() {
        return this.incomingSwiftModules.getSwiftModules();
    }

    public FileCollection getHeaderSearchPaths() {
        return this.incomingHeaders.getHeaderSearchPaths();
    }

    public FileCollection getFrameworkSearchPaths() {
        return this.getObjects().fileCollection().from(new Object[]{this.incomingHeaders.getFrameworkSearchPaths()}).from(new Object[]{this.incomingSwiftModules.getFrameworkSearchPaths()});
    }

    public FileCollection getLinkLibraries() {
        return this.getObjects().fileCollection().from(new Object[]{this.getLinkerInputs().map(this::toLinkLibraries)}).builtBy(new Object[]{this.linkLibrariesConfiguration});
    }

    public FileCollection getLinkFrameworks() {
        return this.getObjects().fileCollection().from(new Object[]{this.getLinkerInputs().map(this::toLinkFrameworks)}).builtBy(new Object[]{this.linkLibrariesConfiguration});
    }

    private void configureLinkerInputs() {
        this.getLinkerInputs().set(this.fromLinkConfiguration());
        this.getLinkerInputs().finalizeValueOnRead();
        this.getLinkerInputs().disallowChanges();
    }

    private Provider<List<LinkerInput>> fromLinkConfiguration() {
        return this.getProviders().provider(() -> this.linkLibrariesConfiguration.getIncoming().getArtifacts().getArtifacts().stream().map(LinkerInput::of).collect(Collectors.toList()));
    }

    public abstract ListProperty<LinkerInput> getLinkerInputs();

    private List<File> toLinkLibraries(List<LinkerInput> inputs) {
        return inputs.stream().filter(it -> !it.isFramework()).map(LinkerInput::getFile).collect(Collectors.toList());
    }

    private List<File> toLinkFrameworks(List<LinkerInput> inputs) {
        return inputs.stream().filter(it -> it.isFramework()).map(LinkerInput::getFile).collect(Collectors.toList());
    }

    public FileCollection getRuntimeLibraries() {
        return this.getObjects().fileCollection().from(new Object[]{this.runtimeLibrariesConfiguration});
    }

    private boolean hasConfiguration(String name) {
        return StreamSupport.stream(this.getConfigurations().getCollectionSchema().getElements().spliterator(), false).anyMatch(it -> it.getName().equals(name));
    }

    static final class LinkerInput {
        private final boolean framework;
        private final File file;

        public static LinkerInput of(ResolvedArtifactResult result) {
            return new LinkerInput(DependencyUtils.isFrameworkDependency((ResolvedArtifactResult)result), result.getFile());
        }

        public LinkerInput(boolean framework, File file) {
            this.framework = framework;
            this.file = file;
        }

        public boolean isFramework() {
            return this.framework;
        }

        public File getFile() {
            return this.file;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LinkerInput)) {
                return false;
            }
            LinkerInput other = (LinkerInput)o;
            if (this.isFramework() != other.isFramework()) {
                return false;
            }
            File this$file = this.getFile();
            File other$file = other.getFile();
            return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFramework() ? 79 : 97);
            File $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            return result;
        }

        public String toString() {
            return "NativeIncomingDependencies.LinkerInput(framework=" + this.isFramework() + ", file=" + this.getFile() + ")";
        }
    }
}

