/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.base.internal.repositories;

import com.google.gson.Gson;
import dev.nokee.runtime.base.internal.repositories.GradleModuleMetadata;
import dev.nokee.runtime.base.internal.repositories.ListingResponse;
import dev.nokee.runtime.base.internal.repositories.Response;
import dev.nokee.runtime.base.internal.repositories.RouteHandler;
import dev.nokee.runtime.base.internal.repositories.StringResponse;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public abstract class AbstractRouteHandler
implements RouteHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractRouteHandler.class.getName());

    public abstract String getContextPath();

    protected abstract boolean isKnownModule(String var1);

    protected abstract boolean isKnownVersion(String var1, String var2);

    protected abstract List<String> findVersions(String var1);

    protected abstract GradleModuleMetadata getResourceMetadata(String var1, String var2);

    protected abstract String handle(String var1, String var2, String var3);

    @Override
    public final Optional<Response> handle(String target) {
        target = target.substring(this.getContextPath().length() + 1);
        int idx = target.indexOf(47);
        String moduleName = target.substring(0, idx);
        if ((idx = (target = target.substring(idx + 1)).indexOf(47)) == -1) {
            if (this.isKnownModule(moduleName)) {
                return Optional.of(new ListingResponse(this.findVersions(moduleName)));
            }
            return Optional.empty();
        }
        String version = target.substring(0, idx);
        if (!this.findVersions(moduleName).contains(version)) {
            LOGGER.info(String.format("The requested module '%s' version '%s' doesn't match current available versions '%s'.", moduleName, version, String.join((CharSequence)", ", this.findVersions(moduleName))));
            return Optional.empty();
        }
        if (!this.isKnownVersion(moduleName, version)) {
            LOGGER.info(String.format("The requested module '%s' version '%s' wasn't found.", moduleName, version));
            return Optional.empty();
        }
        if (target.endsWith(".module")) {
            return Optional.of(new StringResponse(new Gson().toJson((Object)this.getResourceMetadata(moduleName, version))));
        }
        String result = this.handle(moduleName, version, target);
        if (result != null) {
            return Optional.of(new StringResponse(result));
        }
        return Optional.empty();
    }
}

