/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.base.internal.repositories;

import com.google.common.hash.Hashing;
import dev.nokee.runtime.base.internal.repositories.Response;
import dev.nokee.runtime.base.internal.repositories.RouteHandler;
import dev.nokee.runtime.base.internal.repositories.StringResponse;
import java.nio.charset.Charset;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;

public class ContentHashingHandler
implements RouteHandler {
    private final RouteHandler delegate;

    ContentHashingHandler(RouteHandler delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<Response> handle(String target) {
        if (FilenameUtils.isExtension((String)target, (String)"sha1")) {
            return this.delegate.handle(FilenameUtils.removeExtension((String)target)).map(ContentHashingHandler::sha1);
        }
        return this.delegate.handle(target);
    }

    private static Response sha1(Response content) {
        return new StringResponse(Hashing.sha1().hashString((CharSequence)content.getContent(), Charset.defaultCharset()).toString());
    }
}

