/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.base.internal.repositories;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public final class GradleModuleMetadata {
    @NonNull
    private final String formatVersion;
    @NonNull
    private final Component component;
    @NonNull
    private final List<Variant> variants;

    public static GradleModuleMetadata of(@NonNull Component component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        return GradleModuleMetadata.of(component, (List<Variant>)ImmutableList.of());
    }

    public static GradleModuleMetadata of(@NonNull Component component, @NonNull List<Variant> variants) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (variants == null) {
            throw new NullPointerException("variants is marked non-null but is null");
        }
        return new GradleModuleMetadata("1.0", component, variants);
    }

    @NonNull
    public String getFormatVersion() {
        return this.formatVersion;
    }

    @NonNull
    public Component getComponent() {
        return this.component;
    }

    @NonNull
    public List<Variant> getVariants() {
        return this.variants;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleModuleMetadata)) {
            return false;
        }
        GradleModuleMetadata other = (GradleModuleMetadata)o;
        String this$formatVersion = this.getFormatVersion();
        String other$formatVersion = other.getFormatVersion();
        if (this$formatVersion == null ? other$formatVersion != null : !this$formatVersion.equals(other$formatVersion)) {
            return false;
        }
        Component this$component = this.getComponent();
        Component other$component = other.getComponent();
        if (this$component == null ? other$component != null : !((Object)this$component).equals(other$component)) {
            return false;
        }
        List<Variant> this$variants = this.getVariants();
        List<Variant> other$variants = other.getVariants();
        return !(this$variants == null ? other$variants != null : !((Object)this$variants).equals(other$variants));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $formatVersion = this.getFormatVersion();
        result = result * 59 + ($formatVersion == null ? 43 : $formatVersion.hashCode());
        Component $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : ((Object)$component).hashCode());
        List<Variant> $variants = this.getVariants();
        result = result * 59 + ($variants == null ? 43 : ((Object)$variants).hashCode());
        return result;
    }

    public String toString() {
        return "GradleModuleMetadata(formatVersion=" + this.getFormatVersion() + ", component=" + this.getComponent() + ", variants=" + this.getVariants() + ")";
    }

    private GradleModuleMetadata(@NonNull String formatVersion, @NonNull Component component, @NonNull List<Variant> variants) {
        if (formatVersion == null) {
            throw new NullPointerException("formatVersion is marked non-null but is null");
        }
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (variants == null) {
            throw new NullPointerException("variants is marked non-null but is null");
        }
        this.formatVersion = formatVersion;
        this.component = component;
        this.variants = variants;
    }

    public static final class Variant {
        @NonNull
        private final String name;
        @NonNull
        private final Map<String, Object> attributes;
        @NonNull
        private final List<File> files;
        @NonNull
        private final List<Capability> capabilities;

        public Variant(@NonNull String name, @NonNull Map<String, Object> attributes, @NonNull List<File> files, @NonNull List<Capability> capabilities) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (attributes == null) {
                throw new NullPointerException("attributes is marked non-null but is null");
            }
            if (files == null) {
                throw new NullPointerException("files is marked non-null but is null");
            }
            if (capabilities == null) {
                throw new NullPointerException("capabilities is marked non-null but is null");
            }
            this.name = name;
            this.attributes = attributes;
            this.files = files;
            this.capabilities = capabilities;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @NonNull
        public List<File> getFiles() {
            return this.files;
        }

        @NonNull
        public List<Capability> getCapabilities() {
            return this.capabilities;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Variant)) {
                return false;
            }
            Variant other = (Variant)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, Object> this$attributes = this.getAttributes();
            Map<String, Object> other$attributes = other.getAttributes();
            if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
                return false;
            }
            List<File> this$files = this.getFiles();
            List<File> other$files = other.getFiles();
            if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
                return false;
            }
            List<Capability> this$capabilities = this.getCapabilities();
            List<Capability> other$capabilities = other.getCapabilities();
            return !(this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, Object> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            List<File> $files = this.getFiles();
            result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
            List<Capability> $capabilities = this.getCapabilities();
            result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.Variant(name=" + this.getName() + ", attributes=" + this.getAttributes() + ", files=" + this.getFiles() + ", capabilities=" + this.getCapabilities() + ")";
        }

        public static final class Capability {
            private final String group;
            private final String name;
            private final String version;

            public Capability(String group, String name, String version) {
                this.group = group;
                this.name = name;
                this.version = version;
            }

            public String getGroup() {
                return this.group;
            }

            public String getName() {
                return this.name;
            }

            public String getVersion() {
                return this.version;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Capability)) {
                    return false;
                }
                Capability other = (Capability)o;
                String this$group = this.getGroup();
                String other$group = other.getGroup();
                if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                return !(this$version == null ? other$version != null : !this$version.equals(other$version));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $group = this.getGroup();
                result = result * 59 + ($group == null ? 43 : $group.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                return result;
            }

            public String toString() {
                return "GradleModuleMetadata.Variant.Capability(group=" + this.getGroup() + ", name=" + this.getName() + ", version=" + this.getVersion() + ")";
            }
        }

        public static final class File {
            @NonNull
            private final String name;
            @NonNull
            private final String url;
            @NonNull
            private final String size;
            @NonNull
            private final String sha1;
            @NonNull
            private final String md5;

            public static File ofLocalFile(java.io.File f) {
                return new File(f.getName() + ".localpath", f.getName() + ".localpath", String.valueOf(f.getAbsolutePath().getBytes().length), Hashing.sha1().hashString((CharSequence)f.getAbsolutePath(), Charset.defaultCharset()).toString(), Hashing.md5().hashString((CharSequence)f.getAbsolutePath(), Charset.defaultCharset()).toString());
            }

            @NonNull
            public String getName() {
                return this.name;
            }

            @NonNull
            public String getUrl() {
                return this.url;
            }

            @NonNull
            public String getSize() {
                return this.size;
            }

            @NonNull
            public String getSha1() {
                return this.sha1;
            }

            @NonNull
            public String getMd5() {
                return this.md5;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof File)) {
                    return false;
                }
                File other = (File)o;
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                    return false;
                }
                String this$size = this.getSize();
                String other$size = other.getSize();
                if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
                    return false;
                }
                String this$sha1 = this.getSha1();
                String other$sha1 = other.getSha1();
                if (this$sha1 == null ? other$sha1 != null : !this$sha1.equals(other$sha1)) {
                    return false;
                }
                String this$md5 = this.getMd5();
                String other$md5 = other.getMd5();
                return !(this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                String $size = this.getSize();
                result = result * 59 + ($size == null ? 43 : $size.hashCode());
                String $sha1 = this.getSha1();
                result = result * 59 + ($sha1 == null ? 43 : $sha1.hashCode());
                String $md5 = this.getMd5();
                result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
                return result;
            }

            public String toString() {
                return "GradleModuleMetadata.Variant.File(name=" + this.getName() + ", url=" + this.getUrl() + ", size=" + this.getSize() + ", sha1=" + this.getSha1() + ", md5=" + this.getMd5() + ")";
            }

            public File(@NonNull String name, @NonNull String url, @NonNull String size, @NonNull String sha1, @NonNull String md5) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                if (url == null) {
                    throw new NullPointerException("url is marked non-null but is null");
                }
                if (size == null) {
                    throw new NullPointerException("size is marked non-null but is null");
                }
                if (sha1 == null) {
                    throw new NullPointerException("sha1 is marked non-null but is null");
                }
                if (md5 == null) {
                    throw new NullPointerException("md5 is marked non-null but is null");
                }
                this.name = name;
                this.url = url;
                this.size = size;
                this.sha1 = sha1;
                this.md5 = md5;
            }
        }
    }

    public static final class Component {
        @NonNull
        private final String group;
        @NonNull
        private final String module;
        @NonNull
        private final String version;
        @NonNull
        private final Map<String, Object> attributes;

        public static Component of(String group, String module, String version) {
            return new Component(group, module, version, (Map<String, Object>)ImmutableMap.of((Object)"org.gradle.status", (Object)"release"));
        }

        public Component(@NonNull String group, @NonNull String module, @NonNull String version, @NonNull Map<String, Object> attributes) {
            if (group == null) {
                throw new NullPointerException("group is marked non-null but is null");
            }
            if (module == null) {
                throw new NullPointerException("module is marked non-null but is null");
            }
            if (version == null) {
                throw new NullPointerException("version is marked non-null but is null");
            }
            if (attributes == null) {
                throw new NullPointerException("attributes is marked non-null but is null");
            }
            this.group = group;
            this.module = module;
            this.version = version;
            this.attributes = attributes;
        }

        @NonNull
        public String getGroup() {
            return this.group;
        }

        @NonNull
        public String getModule() {
            return this.module;
        }

        @NonNull
        public String getVersion() {
            return this.version;
        }

        @NonNull
        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Component)) {
                return false;
            }
            Component other = (Component)o;
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            Map<String, Object> this$attributes = this.getAttributes();
            Map<String, Object> other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            Map<String, Object> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        public String toString() {
            return "GradleModuleMetadata.Component(group=" + this.getGroup() + ", module=" + this.getModule() + ", version=" + this.getVersion() + ", attributes=" + this.getAttributes() + ")";
        }
    }
}

