/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.base.internal.repositories;

import dev.nokee.runtime.base.internal.repositories.ContentHashingHandler;
import dev.nokee.runtime.base.internal.repositories.Response;
import dev.nokee.runtime.base.internal.repositories.RouteHandler;
import dev.nokee.runtime.base.internal.repositories.RoutingHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class JettyEmbeddedHttpServer
extends AbstractHandler {
    private static final Logger LOGGER = Logger.getLogger(JettyEmbeddedHttpServer.class.getName());
    private final RouteHandler handler;

    public JettyEmbeddedHttpServer(Map<String, RouteHandler> routes) {
        this.handler = new ContentHashingHandler(new RoutingHandler(routes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String path = request.getRequestURI();
            LOGGER.info("Received " + request.getMethod() + " " + path);
            Optional<Response> result = this.handler.handle(path);
            if (result.isPresent()) {
                response.setContentType(result.get().getContentType());
                response.setStatus(200);
                PrintWriter out = response.getWriter();
                out.write(result.get().getContent());
                out.flush();
                return;
            }
            response.sendError(404, "Not found");
        }
        catch (Throwable e) {
            LOGGER.info("An exception occurred during the dispatch of the request: " + e.getMessage());
            response.sendError(404, "Not found");
        }
        finally {
            baseRequest.setHandled(true);
            LOGGER.info("Finish dispatching with " + response.getStatus());
        }
    }
}

